package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayPowerMqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPowerLineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 3697786631581474929L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * 线路电压
     */
    @JsonProperty("VOLTAGE")
    private BigDecimal voltage;

    /**
     * 线路电流
     */
    @JsonProperty("CURRENT")
    private BigDecimal current;

    /**
     * 线路功率
     */
    @JsonProperty("POWER")
    private BigDecimal power;

}
