package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayPowqsfMqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPowqsfLineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -7712877472765619990L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * A相无功功率
     */
    @JsonProperty("QOW_A")
    private BigDecimal qowA;

    /**
     * B相无功功率
     */
    @JsonProperty("QOW_B")
    private BigDecimal qowB;

    /**
     * C相无功功率
     */
    @JsonProperty("QOW_C")
    private BigDecimal qowC;

    /**
     * 总无功功率
     */
    @JsonProperty("QOW_ALL")
    private BigDecimal qowAll;

    /**
     * A相视在功率
     */
    @JsonProperty("SOW_A")
    private BigDecimal sowA;

    /**
     * B相视在功率
     */
    @JsonProperty("SOW_B")
    private BigDecimal sowB;

    /**
     * C相视在功率
     */
    @JsonProperty("SOW_C")
    private BigDecimal sowC;

    /**
     * A相视在功率
     */
    @JsonProperty("SOW_ALL")
    private BigDecimal sowAll;

    /**
     * A相功率因数
     */
    @JsonProperty("FAC_A")
    private BigDecimal facA;

    /**
     * B相功率因数
     */
    @JsonProperty("FAC_B")
    private BigDecimal facB;

    /**
     * C相功率因数
     */
    @JsonProperty("FAC_C")
    private BigDecimal facC;

    /**
     * 总功率因数
     */
    @JsonProperty("FAC_ALL")
    private BigDecimal facAll;

}
