package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 三相运行参数
 *
 * 订阅主题：
 * /ProductKey/ClientName/powqsf
 * 数据格式：
 * {
 *     "TimeStamp":1491355918,
 *     "Lines":[
 *         {
 *             "LineNo":1,
 *             "QOW_A":10,
 *             "QOW_B":10,
 *             "QOW_C":10,
 *             "QOW_ALL":10,
 *             "SOW_A":10,
 *             "SOW_B":10,
 *             "SOW_C":10,
 *             "SOW_ALL":10,
 *             "FAC_A":0.01,
 *             "FAC_B":0.01,
 *             "FAC_C":0.01,
 *             "FAC_ALL":0.01
 *         },
 *         {
 *             "LineNo":2,
 *             "QOW_A":10,
 *             "QOW_B":10,
 *             "QOW_C":10,
 *             "QOW_ALL":10,
 *             "SOW_A":10,
 *             "SOW_B":10,
 *             "SOW_C":10,
 *             "SOW_ALL":10,
 *             "FAC_A":0.01,
 *             "FAC_B":0.01,
 *             "FAC_C":0.01,
 *             "FAC_ALL":0.01
 *         }
 *     ]
 * }
 * QOW_A	A相无功功率	1Var
 * QOW_B	B相无功功率	1Var
 * QOW_C	C相无功功率	1Var
 * QOW_ALL	总无功功率	1Var
 * SOW_A	A相视在功率	1VA
 * SOW_B	B相视在功率	1VA
 * SOW_C	C相视在功率	1VA
 * SOW_ALL	总视在功率	1VA
 * FAC_A	A相功率因数	0.01
 * FAC_B	B相功率因数	0.01
 * FAC_C	C相功率因数	0.01
 * FAC_ALL	总功率因数	0.01
 *
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPowqsfMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -955223846349024181L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayPowqsfLineMqttJsonDto> lines;

}
