package com.gaea.iesms.bm.mqttHandler.service.impl;

import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.iesms.bm.mqttHandler.mapper.MqttmsgLogMapper;
import com.gaea.iesms.bm.mqttHandler.model.entity.CeDevice;
import com.gaea.iesms.bm.mqttHandler.service.SoeRecordAlarmService;
import com.iesms.bizprocessors.common.dao.SoeRecordOnOffAlarmDao;
import com.iesms.bizprocessors.common.entity.AlarmVo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Lin yicheng
 * @date 2022/3/28 10:24
 */
@Service
public class SoeRecordAlarmServiceImpl implements SoeRecordAlarmService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SoeRecordAlarmServiceImpl.class);

    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();

    @Resource
    private MqttmsgLogMapper mqttmsgLogMapper;

    @Resource
    private SoeRecordOnOffAlarmDao soeRecordOnOffAlarmDao;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void UpdateSoeRecordOnOffAlarm(SoeRecordOnOffAlarmDo onOffAlarmDo) {
        String devMeterCommAddr = onOffAlarmDo.getDevMeterCommAddr();
        String devTermCommAddr = onOffAlarmDo.getDevTermCommAddr();
        Long measPointId = onOffAlarmDo.getMeasPointId();
        String soeSortNo = onOffAlarmDo.getSoeSortNo();
        String soeTitle  = onOffAlarmDo.getSoeTitle();

        // 查询表计地址
        SoeRecordOnOffAlarmDo devMeterInfo = null;
        if (StrUtil.isNotEmpty(devMeterCommAddr)) {
            Map<String, String> map = new HashMap<>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("devTermCommAddr", devTermCommAddr);
            devMeterInfo = soeRecordOnOffAlarmDao.getDevMeterInfo(map);
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("measPointId", measPointId.toString());
            devMeterInfo = soeRecordOnOffAlarmDao.getDevMeterInfoByMeasePointId(map);
        }

        //如果表计地址不存在则返回
        if (ObjectUtil.isEmpty(devMeterInfo)) {
            return;
        }

        String orgNo = devMeterInfo.getOrgNo();
        Long devMeterId = devMeterInfo.getId();
        String devMeterName = devMeterInfo.getDevMeterName();
        //根据表计标识获取设备信息
        List<CeDevice> ceDeviceList = mqttmsgLogMapper.getCeDeviceInfo(devMeterId);

        // 查询是否有未复归的告警，如果有则判断是否复归，如果没有则插入
        String alarmInfo = null;
        Map<String, Object> objectMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(ceDeviceList)) {
            CeDevice ceDevice = ceDeviceList.get(0);
            onOffAlarmDo.setSoeObjectType(20);
            onOffAlarmDo.setSoeObjectId(ceDevice.getCeDeviceId());
            onOffAlarmDo.setSoeObjectName(ceDevice.getCeDeviceName());
            objectMap.put("soeObjectId", ceDevice.getCeDeviceId());
            alarmInfo = ">>>>>>>>>>>>设备编号:"+ceDevice.getCeDeviceId()+"--设备名称:"+ceDevice.getCeDeviceName()+"--告警类型:"+soeTitle;
        }else {
            onOffAlarmDo.setSoeObjectType(3);
            onOffAlarmDo.setSoeObjectId(devMeterId);
            onOffAlarmDo.setSoeObjectName(devMeterName);
            objectMap.put("soeObjectId", devMeterId);
            alarmInfo = ">>>>>>>>>>>>表计编号:"+devMeterId+"--表计名称:"+devMeterName+"--告警类型:"+soeTitle;
        }
        objectMap.put("recovery", false);
        objectMap.put("soeSortNo",soeSortNo);
        SoeRecordOnOffAlarmDo beforeOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(objectMap);

        Boolean onOff = onOffAlarmDo.getOnOff();
        onOffAlarmDo.setOrgNo(orgNo);
        onOffAlarmDo.setSoeSortNo(soeSortNo);
        onOffAlarmDo.setSoeGenTime(new Date());
        Map<String, Object> stringMap = new HashMap<>();
        stringMap.put("soeGenvalue", "1");
        String soeGenValue = JsonConvertUtils.convertToString(stringMap);
        onOffAlarmDo.setSoeGenValue(soeGenValue);
        //判断报文告警上送状态,true为应生成告警,false为复归告警
        if (onOff) {
            if(LOGGER.isDebugEnabled()) {
                LOGGER.debug(alarmInfo);
            }
            //若不存在未复归告警则插入告警
            if (ObjectUtil.isNotEmpty(beforeOffAlarmDo)) {
                return;
            }else {
                onOffAlarmDo.setRecovery(false);
                insertSoeRecordOnOffAlarm(onOffAlarmDo);
            }
        } else {
            //若存在未复归告警则复归该告警
            if (ObjectUtil.isNotEmpty(beforeOffAlarmDo)) {
                beforeOffAlarmDo.setRecovery(true);
                beforeOffAlarmDo.setSoeRecTime(new Date());
                Map<String, Object> map = new HashMap<>();
                map.put("soeRecValue", "0");
                String soeRecValue = JsonConvertUtils.convertToString(map);
                beforeOffAlarmDo.setSoeRecValue(soeRecValue);
                beforeOffAlarmDo.setGmtModified(System.currentTimeMillis());
                soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(beforeOffAlarmDo);
            }else {
                return;
            }
        }
    }

    public void insertSoeRecordOnOffAlarm(SoeRecordOnOffAlarmDo onOffAlarmDo) {

        onOffAlarmDo.setId(SNOWFLAKE_GENERATOR.next());
        onOffAlarmDo.setSoeLevel(3);
        onOffAlarmDo.setSendSms(false);
        onOffAlarmDo.setSendSmsCount(0);
        onOffAlarmDo.setSortSn(1);
        onOffAlarmDo.setValid(true);
        onOffAlarmDo.setGmtCreate(System.currentTimeMillis());
        onOffAlarmDo.setGmtModified(System.currentTimeMillis());
        onOffAlarmDo.setCreator("alarmSystem");
        onOffAlarmDo.setInvalider("alarmSystem");
        onOffAlarmDo.setModifier("alarmSystem");
        onOffAlarmDo.setGmtInvalid(0);
        onOffAlarmDo.setVersion(0);
        soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDo(onOffAlarmDo);

        long time2 = System.currentTimeMillis();
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug(" ===================================告警推送开始===================================");
        }
        AlarmVo alarmVo = new AlarmVo();
        alarmVo.setOrgNo(onOffAlarmDo.getOrgNo());
        alarmVo.setDeviceName(onOffAlarmDo.getSoeObjectName());
        alarmVo.setGraveLevel(String.valueOf(onOffAlarmDo.getGraveLevel())); // 默认等级3
        alarmVo.setSoeSortNo(onOffAlarmDo.getSoeSortNo());
        alarmVo.setSoeSortName(onOffAlarmDo.getSoeDesc());
        stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", JSONUtil.toJsonStr(alarmVo));
        long time3 = System.currentTimeMillis();
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("告警推送时间为：" + ((time3 - time2) / 1000));
            LOGGER.debug(" ===================================告警推送结束 ==================================");
        }
    }

}
