package com.gaea.iesms.bm.mqttHandler;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/22
 */
@EnableScheduling
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.mqttHandler.**", "com.gaea.mybatis.plus.**", "com.gaea.spring.cloud.starter.**", "com.iesms.bizprocessors.common.**"})
@MapperScan(basePackages = {"com.iesms.bizprocessors.common.dao.**"},sqlSessionTemplateRef = "iesmsSqlSessionTemplate")
public class MqttHandlerStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(MqttHandlerStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
