package com.gaea.iesms.bm.mqttHandler.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.model.entity.MeasuredValue;
import com.gaea.iesms.bm.mqttHandler.model.entity.MessageAnalysis;
import com.gaea.iesms.bm.mqttHandler.model.entity.SinglePoint;
import com.gaea.iesms.bm.mqttHandler.util.MeasitemcodeProp;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayGetRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoBatchUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayGetResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointListResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointVo;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.utils.ObjectUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmDevTermService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevTermService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author Lin yicheng
 * @date 2022/7/19 14:27
 *  数据处理服务
 */
@Component
public class JinHua104ReceiveMessageHandler implements MessageHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(JinHua104ReceiveMessageHandler.class);

    private static final String UPCOMM_PROTO = "TCP_HUAYUN104";

    private static final String UPCOMM_PRODUCT_KEY = "HUAYUN104";

    @Autowired
    private MeasitemcodeProp measitemcodeProp;

    @Resource
    private GmDevTermService gmDevTermService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevTermServiceImpl")
    private GmopsDevTermService gmopsDevTermService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;
    @Resource
    private DataCenterCommonService dataCenterCommonService;

    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(256, 256, 120, TimeUnit.SECONDS, new LinkedBlockingDeque<>(200), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());


    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        try {
            if (ObjectUtil.isNotEmpty(message.getPayload())) {
                POOL.execute(new Thread(() -> {
                    handle(message);
                }));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * handle 处理类
     * @param
     */
    public void handle(Message<?> message) {
        String payload= (String) message.getPayload();
        //报文解析成实体类
        MessageAnalysis messageAnalysis = JSONUtil.parseObj(payload).toBean(MessageAnalysis.class);
        //终端编号
        String mac = messageAnalysis.getMac();
        //表计地址 区分水表表计
        String ca = messageAnalysis.getCa();
        if (!ca.contains("water")){
            if (mac.length() == 5) {
                mac = "0000000" + mac;
            } else {
                    mac = "0000" + mac;
            }
        }
        if (!ca.contains("water")) {
            ca = "1";
        }
        if (ca.contains("water")){
            ca=ca.substring(5);
        }
        //量测数据项集合
        LOGGER.info("终端表计信息：{}", mac + "---" + ca);
        List<MeasuredValue> measuredValueList = messageAnalysis.getMeasuredValue();
        //遥信数据项集合
        List<SinglePoint> singlePointList = messageAnalysis.getSinglePoint();

        //存放数据Map
        Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap = Maps.newHashMap();
        Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();
        Long now = System.currentTimeMillis();

        //获取运行网关设备
        RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
        runAccessGatewayGetRequest.setProductKey(UPCOMM_PRODUCT_KEY);
        runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
        runAccessGatewayGetRequest.setUpcommLogicAddr(mac);
        R<RunAccessGatewayGetResponse> gatewayResult=dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
        RunAccessGatewayGetResponse runAccessGatewayGetResponse = gatewayResult.getData();
        if (ObjectUtils.isNotEmpty(runAccessGatewayGetResponse) && ObjectUtils.isNotEmpty(runAccessGatewayGetResponse.getRunAccessGateway()) &&
                CollectionUtil.isNotEmpty(runAccessGatewayGetResponse.getRunMeasPointList())) {
            //数据中心更新运行接入网关设备工况信息
            RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
            runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
            runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(now);
            runAccessGatewayOpsInfoUpdateRequest.setGmtMessageUp(now);
            runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(now);
            R runAccessGatewayOpsInfoUpdateResponse = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
            //获取采集终端设备信息
            GmDevTermGetRequest gmDevTermGetRequest = new GmDevTermGetRequest();
            gmDevTermGetRequest.setAccessGatewayId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
            GmDevTermGetResponse gmDevTermGetResponse = gmDevTermService.getGmDevTerm(gmDevTermGetRequest);
            if (gmDevTermGetResponse.isSuccess()) {
                //更新采集终端设备工况信息
                GmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new GmopsDevTermRefreshRequest();
                gmopsDevTermRefreshRequest.setDevTermId(gmDevTermGetResponse.getGmDevTerm().getId());
                gmopsDevTermRefreshRequest.setGmtHeartbeatUp(now);
                gmopsDevTermRefreshRequest.setGmtMessageUp(now);
                gmopsDevTermRefreshRequest.setGmtMeasdataUp(now);
                GmopsDevTermRefreshResponse gmopsDevTermRefreshResponse = gmopsDevTermService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
            }
            for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
                LOGGER.info("量测点标识:{}", runMeasPointVo.getMeasCommAddr() + "---" + runMeasPointVo.getId());
                String measCommAddr = StrUtil.trim(runMeasPointVo.getMeasCommAddr());
                //key为接入网关设备所属产品#上行通讯规约#终端地址#量测通信地址，value为量测点标识，保存key与value的缓存存入gaeadcu11MeasPointIdReverseCache
                measPointIdReverseMap.put(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, mac, measCommAddr), runMeasPointVo.getId());
            }
        }

        //获取量测点标识
        Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, mac, ca));
        Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
        if (measPointId != null) {
            RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
            runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
            runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(now);
            runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(now);
            R runMeasPointOpsInfoUpdateResponse = dataCenterCommonService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
            //对量测项数据进行处理
            if (CollectionUtil.isNotEmpty(measuredValueList)) {
                for (MeasuredValue measuredValue : measuredValueList) {
                    String ioa = measuredValue.getIoa();
                    BigDecimal value = measuredValue.getValue();
                    if (ioa != null && ioa!= "") {
                        Map<String, Object> measDataInfo = Maps.newHashMap();
                        //获取量测项编码
                        String measitemCode = null;
                        try {
                            measitemCode = measitemcodeProp.getMeasitemCodeFromProperties(ioa,(String) message.getHeaders().get("mqtt_receivedTopic"));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (StrUtil.isEmpty(measitemCode)) {
                            continue;
                        }
                        BigDecimal measDataValue = value != null ? value : BigDecimal.ZERO;
                        measDataInfo.put("pointId", measPointId);
                        measDataInfo.put("measItemCode", measitemCode);
                        measDataInfo.put("measDataClass", measDataValue.getClass());
                        measDataInfo.put("measDataValue", measDataValue);
                        measDataInfo.put("measDataSource", 0);
                        insideMap.put(measitemCode, measDataInfo);
                    }
                }
                if (MapUtil.isNotEmpty(insideMap)) {
                    batchMeasDataInfosMap.put(measPointId.toString(), insideMap);
                }
            }
        }

        //处理表计不存在的数据
        if (StringUtils.isNotEmpty(ca)){
            //获取原存在表计
            R<RunMeasPointListResponse> runMeasPointListBySn = dataCenterCommonService.getRunMeasPointListBySn(mac);
            RunMeasPointListResponse runMeasPointListResponse= runMeasPointListBySn.getData();
            List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
            List<String> measCommAddrList=runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
            //若不存在上报表计 则插入相应实体模型
            if (!measCommAddrList.contains(ca)) {
                R flag = dataCenterCommonService.brushMeter(mac, ca, TopicEnum.JINHUA104.getTopic());
                LOGGER.info("===================终端" + mac + "表计地址" + ca+"插入成功！！！");
            }
        }


        if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
            //数据中心批量更新数据
            dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
            //数据中心批量更新量测点工况信息
            RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest = new RunMeasPointOpsInfoBatchUpdateRequest();
            runMeasPointOpsInfoBatchUpdateRequest.setMeasPointIdList(Lists.newArrayList(Long.valueOf(batchMeasDataInfosMap.keySet().toString())));
            runMeasPointOpsInfoBatchUpdateRequest.setGmtMessageUp(now);
            runMeasPointOpsInfoBatchUpdateRequest.setGmtMeasdataUp(now);
            R runMeasPointOpsInfoBatchUpdateResponse = dataCenterCommonService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
        }

        if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
            LOGGER.info("全部数据：{}", batchMeasDataInfosMap);
            //更新量测表计设备工况
            for (String pointIdString : batchMeasDataInfosMap.keySet()) {
                Long pointId=Long.valueOf(pointIdString);
                Map<String, Map<String, Object>> insideMap1 = batchMeasDataInfosMap.get(pointId);
                GmDevMeterGetRequest gmDevMeterGetRequest = new GmDevMeterGetRequest();
                gmDevMeterGetRequest.setMeasPointId(pointId);
                GmDevMeterGetResponse gmDevMeterGetResponse = gmDevMeterService.getGmDevMeter(gmDevMeterGetRequest);
                GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
                if (gmDevMeterGetResponse.isSuccess()) {
                    gmopsDevMeterRefreshRequest = new GmopsDevMeterRefreshRequest();
                    gmopsDevMeterRefreshRequest.setDevMeterId(gmDevMeterGetResponse.getGmDevMeter().getId());
                    gmopsDevMeterRefreshRequest.setGmtMessageUp(now);
                    gmopsDevMeterRefreshRequest.setGmtMeasdataUp(now);
                    Map<String, Object> measDataInfoSetMap = Maps.newHashMap();
                    for (String measItemCode : insideMap1.keySet()) {
                        Map<String, Object> measDataInfo1 = insideMap1.get(measItemCode);
                        gmopsDevMeterRefreshRequest.setGmtReadingUp(now);
                        measDataInfoSetMap.put(measItemCode, measDataInfo1.get("measDataValue"));
                    }
                    gmopsDevMeterRefreshRequest.setMeasDataInfoSet(JsonConvertUtils.convertToString(measDataInfoSetMap));
                }
                if (ObjectUtil.isNotEmpty(gmopsDevMeterRefreshRequest)) {
                    GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = gmopsDevMeterService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
                }
            }
        }
    }

}
