package com.gaea.iesms.bm.mqttHandler.model.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author Dulifeng
 * @date 2023/4/11
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MqttmsgReceivedLog {

    /**
     * ID
     */
    private Long id;

    /**
     * 报文体
     */
    private String payload;

    /**
     * 主题
     */
    private String topic;

    /**
     * 服务质量
     */
    private int qos;

    /**
     * 是否保存
     */
    private int retained;

    /**
     * 是否复制
     */
    private int duplicate;

    /**
     * 接收消息产品
     */
    private String receivedProductKey;

    /**
     * 接收消息客户端标识
     */
    private String receivedClientId;

    /**
     * 接收消息标识
     */
    private String receivedMessageId;

    /**
     * 创建时间
     */
    private Long gmtCreate;

    /**
     *是否报错 0-正常 1-有误
     */
    private int errorFlag;

    /**
     *报错信息
     */
    private String errorMessage;
}
