package com.gaea.iesms.bm.mqttHandler.model.entity;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2025/4/28 14:17
 */
@Data
public class MultifunctionalMeterData {
    private String ca;
    private long ts;
    private Signature signature;
    private DevStatus devstatus;
    private int ct;
    private Energy forward_energy;
    private Energy reverse_energy;
    private Voltage voltage;
    private Current current;
    private Power power;
    private Frequency frequency;
    private RuntimeDo runtime;

    @Data
    public static class Signature {
        private String type;
        private int id;
        private String name;
        private String display_name;
    }

    @Data
    public static class DevStatus {
        private boolean online;
        private boolean run;
        private boolean alarm;
        private boolean fault;
    }

    @Data
    public static class Energy {
        private double total;
        private double sharp;
        private double peak;
        private double flat;
        private double valley;
    }

    @Data
    public static class Voltage {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Current {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Power {
        private Active active;
        private Reactive reactive;
        private Apparent apparent;
        private Factor factor;
    }

    @Data
    public static class Active {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Reactive {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Apparent {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Factor {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }

    @Data
    public static class Frequency {
        private double total;
        @JsonProperty("phase_a")
        private double phaseA;
        @JsonProperty("phase_b")
        private double phaseB;
        @JsonProperty("phase_c")
        private double phaseC;
    }
    @Data
    public static class RuntimeDo {
        private Voltage voltage;
        private Current current;
        private Power power;
    }
}
