package com.gaea.iesms.bm.mqttHandler.model.entity;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
/**
 * @description:PCS设备数据实体类
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2025/4/28 14:16
 */
@Data
public class PCSDeviceData {
    private String ca;
    // 数据时间点，相对于UTC-0 1970-1-1 0点的毫秒数
    private long ts;
    // 设备说明
    private Signature signature;
    // 设备工作状态
    private DevStatus devstatus;
    // 当前是否处于远程控制状态
    private boolean remote_control;
    // 并网状态
    private boolean grid_interconnection;
    // 充放电状态 -1:充电, 0:静置, 1:放电
    private int charge_status;
    // 工作模式
    private int work_mode;
    // 逆变器模块温度
    private double temperature;
    // 环境温度
    private double environ_temperature;
    // 交流侧运行数据
    private ACRuntime ac_runtime;
    // 充电量数据
    private ACCounter ac_charge;
    // 放电量数据
    private ACCounter ac_discharge;
    // 直流支路运行状态和参数数组
    private Branch[] branch;

    // 设备签名内部类
    @Data
    public static class Signature {
        // 设备类型
        private String type;
        // 设备ID，EMS自编，建议从0开始
        private int id;
        // 设备名称
        private String name;
        // 显示名称
        private String display_name;
    }

    // 设备状态内部类
    @Data
    public static class DevStatus {
        // 通讯状态，true:在线，false:断线
        private boolean online;
        // 开机状态，true:运行，false:停机
        private boolean run;
        // 告警状态，true:异常，false:正常
        private boolean alarm;
        // 故障状态，true:异常，false:正常
        private boolean fault;
    }

    // 交流侧运行时数据内部类
    @Data
    public static class ACRuntime {
        // 电压数据
        private Voltage voltage;
        // 电流数据
        private Current current;
        // 交流功率数据
        private Power power;
        // 频率数据
        private double frequency;
    }

    // 电压数据内部类
    @Data
    public static class Voltage {
        // 总计电压
        private double total;
        // A相电压
        @JsonProperty("phase_a")
        private double phaseA;
        // B相电压
        @JsonProperty("phase_b")
        private double phaseB;
        // C相电压
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 电流数据内部类
    @Data
    public static class Current {
        // 总计电流
        private double total;
        // A相电流
        @JsonProperty("phase_a")
        private double phaseA;
        // B相电流
        @JsonProperty("phase_b")
        private double phaseB;
        // C相电流
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 交流功率数据内部类
    @Data
    public static class Power {
        // 有功功率数据
        private Active active;
        // 无功功率数据
        private Reactive reactive;
        // 视在功率数据
        private Apparent apparent;
        // 功率因素数据
        private Factor factor;
    }

    // 有功功率数据内部类
    @Data
    public static class Active {
        // 总计有功功率
        private double total;
        // A相有功功率
        @JsonProperty("phase_a")
        private double phaseA;
        // B相有功功率
        @JsonProperty("phase_b")
        private double phaseB;
        // C相有功功率
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 无功功率数据内部类
    @Data
    public static class Reactive {
        // 总计无功功率
        private double total;
        // A相无功功率
        @JsonProperty("phase_a")
        private double phaseA;
        // B相无功功率
        @JsonProperty("phase_b")
        private double phaseB;
        // C相无功功率
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 视在功率数据内部类
    @Data
    public static class Apparent {
        // 总计视在功率
        private double total;
        // A相视在功率
        @JsonProperty("phase_a")
        private double phaseA;
        // B相视在功率
        @JsonProperty("phase_b")
        private double phaseB;
        // C相视在功率
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 功率因素数据内部类
    @Data
    public static class Factor {
        // 总计功率因素
        private double total;
        // A相功率因素
        @JsonProperty("phase_a")
        private double phaseA;
        // B相功率因素
        @JsonProperty("phase_b")
        private double phaseB;
        // C相功率因素
        @JsonProperty("phase_c")
        private double phaseC;
    }

    // 充放电量计数器内部类
    @Data
    public static class ACCounter {
        // 总累计量
        private double total;
        // 当日累计量
        private double daily;
        // 当次累计量
        private double round;
    }

    // 直流支路内部类
    @Data
    public static class Branch {
        // 直流支路id
        private int id;
        // 直流支路名称
        private String name;
        // 直流支路运行时参数
        private BranchRuntime runtime;
    }

    // 直流支路运行时参数内部类
    @Data
    public static class BranchRuntime {
        // 电压
        private double voltage;
        // 电流
        private double current;
        // 功率
        private double power;
    }
}
