package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/temp
 * 数据格式：
 *
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayTempMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 2008561445455903781L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayTempLineMqttJsonDto> lines;

}
