//package com.gaea.iesms.bm.mqttHandler.task;
//
//import cn.hutool.core.collection.CollectionUtil;
//import cn.hutool.core.map.MapUtil;
//import cn.hutool.core.util.ObjectUtil;
//import cn.hutool.core.util.StrUtil;
//import cn.hutool.http.HttpRequest;
//import cn.hutool.http.HttpResponse;
//import cn.hutool.json.JSONUtil;
//import com.alibaba.fastjson.JSONArray;
//import com.alibaba.fastjson.JSONObject;
//import com.easesource.commons.util.StringUtils;
//import com.easesource.commons.util.convert.JsonConvertUtils;
//import com.gaea.base.core.R;
//import com.gaea.iesms.bm.mqttHandler.config.MwConfig;
//import com.gaea.iesms.bm.mqttHandler.model.entity.EMSData;
//import com.gaea.iesms.bm.mqttHandler.model.entity.EMSDevData;
//import com.gaea.iesms.bm.mqttHandler.model.entity.EMSReceiveMessageDo;
//import com.gaea.iesms.core.feign.enums.TopicEnum;
//import com.gaea.iesms.core.feign.request.alarm.PushAlarmRequest;
//import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayGetRequest;
//import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayOpsInfoUpdateRequest;
//import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoBatchUpdateRequest;
//import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoUpdateRequest;
//import com.gaea.iesms.core.feign.request.iot.RemoteGmDevMeterGetRequest;
//import com.gaea.iesms.core.feign.request.iot.RemoteGmDevTermGetRequest;
//import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevMeterRefreshRequest;
//import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevTermRefreshRequest;
//import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayGetResponse;
//import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointListResponse;
//import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointVo;
//import com.gaea.iesms.core.feign.response.iot.RemoteGmDevMeterGetResponse;
//import com.gaea.iesms.core.feign.response.iot.RemoteGmDevTermGetResponse;
//import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevMeterRefreshResponse;
//import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevTermRefreshResponse;
//import com.gaea.iesms.core.feign.service.DataCenterCommonService;
//import com.gaea.iesms.core.feign.service.JrEmsCommonService;
//import com.gaea.iesms.core.feign.service.RemoteAlarmService;
//import com.gaea.iesms.core.feign.service.RemoteIotService;
//import com.gaea.utils.ObjectUtils;
//import com.google.common.base.Joiner;
//import com.google.common.collect.Maps;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.scheduling.annotation.Scheduled;
//import org.springframework.stereotype.Component;
//
//import javax.annotation.Resource;
//import java.io.IOException;
//import java.io.InputStream;
//import java.io.InputStreamReader;
//import java.math.BigDecimal;
//import java.nio.charset.StandardCharsets;
//import java.util.*;
//import java.util.stream.Collectors;
//
///**
// *
// */
//@Component
//public class MwTask {
//
//    // 明旺文档 https://thoughts.teambition.com/share/61308959a455f900416a27ed
//    private static final String UPCOMM_PROTO = "JREMS";
//    private static final String UPCOMM_PRODUCT_KEY = "JREMS";
//    private static final Logger LOGGER = LoggerFactory.getLogger(MwTask.class);
//
//    @Resource
//    private DataCenterCommonService dataCenterCommonService;
//
//    @Resource
//    private JrEmsCommonService jrEmsCommonService;
//
//    @Resource
//    private RemoteIotService remoteIotService;
//
//    @Resource
//    private MwConfig mwConfig;
//
//    @Resource
//    private RemoteAlarmService remoteAlarmService;
//
//    @Scheduled(cron = "0 0/5 * * * ?")
//    public void execute() {
//        String baseUrl = mwConfig.getUrl();
//        String appKey = mwConfig.getAppKey();
//        String appToken = mwConfig.getAppToken();
//
//        // 获取 Token
//        HttpResponse tokenResponse = sendPost(baseUrl + "auth", appKey, appToken, null);
//        if (!tokenResponse.isOk()) {
//            LOGGER.warn("获取 Token 失败");
//            return;
//        }
//
//        String accessToken = parseAccessToken(tokenResponse.body());
//        if (StrUtil.isEmpty(accessToken)) {
//            LOGGER.warn("Token 解析失败");
//            return;
//        }
//
//        processDeviceData("MWJRGF001", accessToken);
//        processDeviceData("MWJRGK001", accessToken);
//    }
//
//    private String parseAccessToken(String responseBody) {
//        try {
//            JSONObject jsonObject = JSONObject.parseObject(responseBody);
//            return jsonObject.getJSONObject("data").getString("accessToken");
//        } catch (Exception e) {
//            LOGGER.warn("解析 Token 失败: {}", responseBody, e);
//            return null;
//        }
//    }
//
//    private void processDeviceData(String deviceSn, String accessToken) {
//        List<String> anaList = getMeasitemCodeList("ana", deviceSn);
//        List<String> accList = getMeasitemCodeList("acc", deviceSn);
//
//        String baseUrl = mwConfig.getUrl();
//        String appKey = mwConfig.getAppKey();
//
//        JSONArray anaData = fetchData(baseUrl + "hsda/ana", appKey, accessToken, anaList);
//        if (anaData != null) {
//            processData(deviceSn,"ana", anaData);
//        }
//
//        JSONArray accData = fetchData(baseUrl + "hsda/acc", appKey, accessToken, accList);
//        if (accData != null) {
//            processData(deviceSn,"acc", accData);
//        }
//    }
//
//    private JSONArray fetchData(String url, String appKey, String accessToken, List<String> ids) {
//        if (ids == null || ids.isEmpty()) {
//            return null;
//        }
//
//        Map<String, List<String>> body = Collections.singletonMap("ids", ids);
//        HttpResponse response = sendPost(url, appKey, accessToken, JSONObject.toJSONString(body));
//        if (!response.isOk()) {
//            return null;
//        }
//
//        try {
//            JSONObject json = JSONObject.parseObject(response.body());
//            return json.getJSONArray("data");
//        } catch (Exception e) {
//            LOGGER.warn("解析响应失败: {}", response.body(), e);
//            return null;
//        }
//    }
//
//    private HttpResponse sendPost(String url, String appKey, String accessToken, String body) {
//        HttpRequest request = HttpRequest.post(url)
//                .header("x-ie-access-key", appKey)
//                .header("x-ie-access-token", accessToken)
//                .header("x-ie-token-type", "bearer")
//                .timeout(5000);
//
//        if (body != null) {
//            request.body(body);
//        }
//
//        return request.execute();
//    }
//
//    public List<String> getMeasitemCodeList(String modelAttribute, String sn) {
//        String propName = sn.contains("GF") ? "/mwgf.properties" : "/mwgk.properties";
//        Properties props = loadProperties(propName);
//        List<String> result = new ArrayList<>();
//        String prefix = modelAttribute.toLowerCase();
//        for (String key : props.stringPropertyNames()) {
//            if (key.toLowerCase().contains(modelAttribute)) {
//                int index = key.indexOf(modelAttribute);
//                if (index != -1) {
//                    String code = key.substring(index + prefix.length());
//                    result.add(code);
//                }
//            }
//        }
//        return result;
//    }
//
//    public String getMeasitemCode(String modelAttribute, String sn) {
//        String propName = sn.contains("GF") ? "/mwgf.properties" : "/mwgk.properties";
//        Properties props = loadProperties(propName);
//        return props.getProperty(modelAttribute);
//    }
//
//    private Properties loadProperties(String propName) {
//        Properties props = new Properties();
//        InputStream in = this.getClass().getResourceAsStream(propName);
//        if (in == null) {
//            LOGGER.error("找不到配置文件: {}", propName);
//            return props;
//        }
//
//        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8)) {
//            props.load(reader);
//        } catch (Exception e) {
//            LOGGER.error("加载配置文件失败: {}", propName, e);
//        }
//        return props;
//    }
//
//
//    public void processData(String sn,String type,JSONArray data) {
//
//        //存放数据Map
//        Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();
//        Long now = System.currentTimeMillis();
//
//        //获取运行网关设备
//        RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
//        runAccessGatewayGetRequest.setProductKey(UPCOMM_PRODUCT_KEY);
//        runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
//        runAccessGatewayGetRequest.setUpcommLogicAddr(sn);
//        R<RunAccessGatewayGetResponse> gatewayResult=dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
//        RunAccessGatewayGetResponse runAccessGatewayGetResponse = gatewayResult.getData();
//        if (ObjectUtils.isNotEmpty(runAccessGatewayGetResponse) && ObjectUtils.isNotEmpty(runAccessGatewayGetResponse.getRunAccessGateway()) &&
//                CollectionUtil.isNotEmpty(runAccessGatewayGetResponse.getRunMeasPointList())) {
//            //数据中心更新运行接入网关设备工况信息
//            RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
//            runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
//            runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(now);
//            runAccessGatewayOpsInfoUpdateRequest.setGmtMessageUp(now);
//            runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(now);
//            R runAccessGatewayOpsInfoUpdateResponse = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
//            //获取采集终端设备信息
//            RemoteGmDevTermGetRequest remoteGmDevTermGetRequest=new RemoteGmDevTermGetRequest();
//            remoteGmDevTermGetRequest.setAccessGatewayId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
//            R<RemoteGmDevTermGetResponse> gmDevTerm = remoteIotService.getGmDevTerm(remoteGmDevTermGetRequest);
//            if (gmDevTerm.isSuccess()) {
//                //更新采集终端设备工况信息
//                RemoteGmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new RemoteGmopsDevTermRefreshRequest();
//                gmopsDevTermRefreshRequest.setDevTermId(gmDevTerm.getData().getGmDevTerm().getId());
//                gmopsDevTermRefreshRequest.setGmtHeartbeatUp(now);
//                gmopsDevTermRefreshRequest.setGmtMessageUp(now);
//                gmopsDevTermRefreshRequest.setGmtMeasdataUp(now);
//                R<RemoteGmopsDevTermRefreshResponse> remoteGmopsDevTermRefreshResponseR = remoteIotService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
//            }
//            for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
////                    LOGGER.info("量测点标识:{}", runMeasPointVo.getMeasCommAddr() + "---" + runMeasPointVo.getId());
//                String measCommAddr = StrUtil.trim(runMeasPointVo.getMeasCommAddr());
//                //key为接入网关设备所属产品#上行通讯规约#终端地址#量测通信地址，value为量测点标识，保存key与value的缓存存入gaeadcu11MeasPointIdReverseCache
//                measPointIdReverseMap.put(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, measCommAddr), runMeasPointVo.getId());
//            }
//        }
//
//        // 存储表计ID（使用LinkedHashSet去重并保持顺序）
//        Set<String> caSet = new LinkedHashSet<>();
//        String propName = sn.contains("GF") ? "/mwgf.properties" : "/mwgk.properties";
//        Properties props = loadProperties(propName);
//        for (String key : props.stringPropertyNames()) {
//            if (key.length() >= 16) {
//                String meterId = key.substring(0, 14);
//                caSet.add(meterId);
//            }
//        }
//
//        for (String ca : caSet) {
//            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, ca));
//            if  (measPointId == null) {
//                LOGGER.error("找不到量测点标识: {} - {}", sn,ca);
//                continue;
//            }
//
//            Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap = Maps.newHashMap();
//            Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
//            data.forEach(item -> {
//                Map<String, Object> measDataInfo = Maps.newHashMap();
//                //获取量测点标识
//                String measitemCode = getMeasitemCode(ca + type + JSONUtil.parseObj(item).get("id"), sn);
//                if (StrUtil.isEmpty(measitemCode)) {
//                    return;
//                }
//                BigDecimal value = JSONUtil.parseObj(item).getBigDecimal("value");
//                if (type.equals("acc")){
//                    value = JSONUtil.parseObj(item).getBigDecimal("markValue");
//                }
//                BigDecimal measDataValue = value != null ? value : BigDecimal.ZERO;
//                measDataInfo.put("pointId", measPointId);
//                measDataInfo.put("measItemCode", measitemCode);
//                measDataInfo.put("measDataClass", "java.math.BigDecimal");
//                measDataInfo.put("measDataValue", measDataValue);
//                measDataInfo.put("measDataSource", 0);
//                insideMap.put(measitemCode, measDataInfo);
//                //明旺策略发起
//                if (ca.equals("mwgk2025051301")&&measitemCode.equals("gen_watt_acpt")){
//                    R r = jrEmsCommonService.targetControl(Double.parseDouble(measDataValue.toString()), "1907700006248431618");
//                }
//
//            });
//            if (MapUtil.isNotEmpty(insideMap)) {
//                batchMeasDataInfosMap.put(measPointId.toString(), insideMap);
//            }
//            //处理表计不存在的数据
//            if (StringUtils.isNotEmpty(ca)) {
//                //获取原存在表计
//                R<RunMeasPointListResponse> runMeasPointListBySn = dataCenterCommonService.getRunMeasPointListBySn(sn);
//                RunMeasPointListResponse runMeasPointListResponse = runMeasPointListBySn.getData();
//                List<RunMeasPointVo> runMeasPointList = runMeasPointListResponse.getRunMeasPointList();
//                List<String> measCommAddrList = runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
//                //若不存在上报表计 则插入相应实体模型
//                if (!measCommAddrList.contains(ca)) {
//                    R flag = dataCenterCommonService.brushMeter(sn, ca, TopicEnum.JINHUA104.getTopic());
//                    LOGGER.info("===================终端" + sn + "表计地址" + ca + "插入成功！！！");
//                }
//            }
//
//            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
//                //数据中心批量更新数据
//                dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
//                //数据中心批量更新量测点工况信息
//                RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest = new RunMeasPointOpsInfoBatchUpdateRequest();
//                runMeasPointOpsInfoBatchUpdateRequest.setMeasPointIdList(batchMeasDataInfosMap.keySet().stream().map(Long::valueOf).collect(Collectors.toList()));
//                runMeasPointOpsInfoBatchUpdateRequest.setGmtMessageUp(now);
//                runMeasPointOpsInfoBatchUpdateRequest.setGmtMeasdataUp(now);
//                R runMeasPointOpsInfoBatchUpdateResponse = dataCenterCommonService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
//            }
////            if (ca.contains("mwgk2025051302")) {
//                remoteAlarmService.dataCenterBoundSoeRecord();
////            }
//            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
//                //更新量测表计设备工况
//                for (String pointIdString : batchMeasDataInfosMap.keySet()) {
//                    Long pointId = Long.valueOf(pointIdString);
//                    Map<String, Map<String, Object>> insideMap1 = batchMeasDataInfosMap.get(pointId.toString());
//                    RemoteGmDevMeterGetRequest gmDevMeterGetRequest = new RemoteGmDevMeterGetRequest();
//                    gmDevMeterGetRequest.setMeasPointId(pointId);
//                    R<RemoteGmDevMeterGetResponse> r = remoteIotService.getGmDevMeter(gmDevMeterGetRequest);
//                    RemoteGmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
//                    if (r.getCode() == 200 && r.getData().getGmDevMeter() != null) {
//                        RemoteGmDevMeterGetResponse remoteGmDevMeterGetResponse = r.getData();
//                        gmopsDevMeterRefreshRequest = new RemoteGmopsDevMeterRefreshRequest();
//                        gmopsDevMeterRefreshRequest.setDevMeterId(remoteGmDevMeterGetResponse.getGmDevMeter().getId());
//                        gmopsDevMeterRefreshRequest.setGmtMessageUp(now);
//                        gmopsDevMeterRefreshRequest.setGmtMeasdataUp(now);
//                        Map<String, Object> measDataInfoSetMap = Maps.newHashMap();
//                        for (String measItemCode : insideMap1.keySet()) {
//                            Map<String, Object> measDataInfo1 = insideMap1.get(measItemCode);
//                            gmopsDevMeterRefreshRequest.setGmtReadingUp(now);
//                            measDataInfoSetMap.put(measItemCode, measDataInfo1.get("measDataValue"));
//                        }
//                        gmopsDevMeterRefreshRequest.setMeasDataInfoSet(JsonConvertUtils.convertToString(measDataInfoSetMap));
//                    }
//                    if (ObjectUtil.isNotEmpty(gmopsDevMeterRefreshRequest)) {
//                        R<RemoteGmopsDevMeterRefreshResponse> remoteGmopsDevMeterRefreshResponseR = remoteIotService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
//                    }
//                }
//
//            }
//        }
//    }
//}
