package com.gaea.iesms.bm.mqttHandler.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.constant.MqttSendTopicEnum;
import com.gaea.iesms.bm.mqttHandler.gateway.MqttGateway;
import com.gaea.iesms.bm.mqttHandler.util.MeasitemcodeProp;
import com.gaea.iesms.core.feign.request.mqttHandler.*;
import com.gaea.iesms.core.feign.request.togateway.AllMqttIotDTO;
import com.gaea.iesms.core.feign.request.togateway.EmsMqttIotDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/11/29 15:05
 */
@Api(tags = "ems控制")
@RestController
@RequestMapping("/emsControl")
public class EMSControlController {


    @Autowired
    private MqttGateway mqttGateway;

    @Autowired
    private MeasitemcodeProp measitemcodeProp;


    public static  SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 自发自用模式
     */
    @ApiOperation(value="自发自用模式")
    @PostMapping("/sponteness")
    public R sponteness(@RequestBody CommonStrategyDTO commonStrategyDTO) {
        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()){
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setSn(devTermNo);
            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setTime(format.format(new Date()));
            //执行类型
            allMqttIotDTO.setType("SPONTENESS");
            if (commonStrategyDTO.getStatus().equals("1")){
                String string = JSON.toJSONString(commonStrategyDTO);
                allMqttIotDTO.setValue(string);
            }else{
                allMqttIotDTO.setValue("0");
            }
            //统一格式定义
            String sendTopic= MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() +devTermNo;
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return R.ok();
    }


    /**
     * 削峰填谷模式
     */
    @ApiOperation(value="削峰填谷模式")
    @PostMapping("/smoothing")
    public R smoothing(@RequestBody CommonStrategyDTO commonStrategyDTO) {
        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()) {
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setSn(devTermNo);
            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setTime(format.format(new Date()));
            //执行类型
            allMqttIotDTO.setType("SMOOTHING");
            if (commonStrategyDTO.getSmoothingDTOList().size()>0){
                //类型
                allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
            }else {
                allMqttIotDTO.setValue("0");
            }
            String sendTopic= MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() +devTermNo;
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return R.ok();
    }



    /**
     * 需量控制模式
     */
    @ApiOperation(value="需量控制模式")
    @PostMapping("/regulation")
    public R regulation(@RequestBody CommonStrategyDTO commonStrategyDTO) {
        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()) {
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setSn(devTermNo);
            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setTime(format.format(new Date()));
            //执行类型
            allMqttIotDTO.setType("REGULATION");
            //判断是否开启需量控制模式
            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
            String sendTopic = MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() + devTermNo;
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return R.ok();
    }

    /**
     * 储能控制
     */
    @ApiOperation(value="储能控制")
    @PostMapping("/energyStorageControl")
    public R energyStorageControl(@RequestBody CommonStrategyDTO commonStrategyDTO) {
        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()) {
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setSn(devTermNo);
            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setTime(format.format(new Date()));
            //执行类型
            allMqttIotDTO.setType("write");
            //判断是否开启需量控制模式
            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
            String sendTopic = MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() + devTermNo;
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return R.ok();
    }

//    /**
//     * 阈值设置
//     */
//    @ApiOperation(value="阈值设置")
//    @PostMapping("/thresholdsetting")
//    public R thresholdsetting(@RequestBody CommonStrategyDTO commonStrategyDTO) {
//        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()) {
//            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
//            allMqttIotDTO.setSn(devTermNo);
//            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
//            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
//            allMqttIotDTO.setTime(format.format(new Date()));
//            //执行类型
//            allMqttIotDTO.setType("write");
//            //判断是否开启需量控制模式
//            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
//            String sendTopic = MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() + devTermNo;
//            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
//        }
//        return R.ok();
//    }
//
//
//    @ApiOperation(value="手动控制")
//    @PostMapping("/manualControl")
//    public R manualControl(@RequestBody CommonStrategyDTO commonStrategyDTO){
//        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()) {
//            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
//            allMqttIotDTO.setSn(devTermNo);
//            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
//            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
//            allMqttIotDTO.setTime(format.format(new Date()));
//            //执行类型
//            allMqttIotDTO.setType("write");
//            //判断是否开启需量控制模式
//            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
//            String sendTopic = MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() + devTermNo;
//            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
//        }
//        return R.ok();
//    }


    @ApiOperation(value="光伏控制")
    @PostMapping("/systemPhotovoltaic")
    public R systemPhotovoltaic( @RequestBody CommonStrategyDTO commonStrategyDTO){
        for (String devTermNo:commonStrategyDTO.getDevTermNoSet()){
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setSn(devTermNo);
            //如果是有数据项的就发数据项如果没有数据项的则发fun函数名称
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setTime(format.format(new Date()));
            //执行类型
            allMqttIotDTO.setType("PHOTOVOLTAICSETTINGS");
            //判断是否开启需量控制模式
            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
            String sendTopic = MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic() + devTermNo;
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return  R.ok();
    }


    @ApiOperation(value="空调控制")
    @PostMapping("/airConditioningSettings")
    public R airConditioningSettings(@RequestBody  CommonStrategyDTO commonStrategyDTO){
        for (SnAndMeterDTO snAndMeterDTO : commonStrategyDTO.getSnAndMeterDto()) {
            AllMqttIotDTO allMqttIotDTO = new AllMqttIotDTO();
            allMqttIotDTO.setType("write");
            allMqttIotDTO.setSn(snAndMeterDTO.getSn());
            allMqttIotDTO.setTime(format.format(new Date()));
            allMqttIotDTO.setTagId(commonStrategyDTO.getType());
            allMqttIotDTO.setPublicAddr(commonStrategyDTO.getAddId());
            allMqttIotDTO.setValue(JSON.toJSONString(commonStrategyDTO));
            String sendTopic =MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic()+snAndMeterDTO.getSn();
            mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        }
        return  R.ok();
    }

    @ApiOperation(value="统一格式控制下发")
    @PostMapping("/control")
    public R control(@RequestBody  AllMqttIotDTO allMqttIotDTO){
        String sendTopic =MqttSendTopicEnum.ALLIOTGATEWAYCMD.getTopic()+allMqttIotDTO.getSn();
        mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(allMqttIotDTO));
        return  R.ok();
    }

    @ApiOperation(value="统一格式控制下发")
    @PostMapping("/emsControl")
    public R emsControl(@RequestBody List<EmsMqttIotDTO> emsMqttIotDTOList){
        emsMqttIotDTOList.forEach(emsMqttIotDTO -> {
            try {
                String point =measitemcodeProp.getMeasitemCodeFromProperties(emsMqttIotDTO.getPointCode(),"ems");
                if (Objects.isNull(point)){
                    return;
                }
                emsMqttIotDTO.setPoint(point);
                String type= measitemcodeProp.getMeasitemCodeFromProperties(point,"ems");
                emsMqttIotDTO.setType(type);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        String sendTopic =MqttSendTopicEnum.EMSCMS.getTopic()+emsMqttIotDTOList.get(0).getSn();
        mqttGateway.sendToMqtt(sendTopic, JSONObject.toJSONString(emsMqttIotDTOList));
        return  R.ok();
    }

}
