package com.gaea.iesms.bm.mqttHandler.controller;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.gateway.MqttGateway;
import com.gaea.iesms.core.feign.request.mqttHandler.SwitchLineStatusUpdateRequest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2024/8/6 10:45
 */
@Api(tags = "jala控制")
@RestController
@RequestMapping("/jalaControl")
public class JalaControlController {

    @Autowired
    private MqttGateway mqttGateway;

    @PostMapping("/updateSwitchLineStatus")
    public R updateSwitchLineStatus(@RequestBody SwitchLineStatusUpdateRequest switchLineStatusUpdateRequest) {

        Map<String, Object> params = Maps.newLinkedHashMap();
        List<Map<String, Integer>> lines = Lists.newArrayList();
        Map<Integer, Boolean> measSnToStatusMap = switchLineStatusUpdateRequest.getMeasSnToStatusMap();
        if (measSnToStatusMap != null && measSnToStatusMap.size() > 0) {
            for (Integer measSn : measSnToStatusMap.keySet()) {
                Map<String, Integer> lineMap = Maps.newLinkedHashMap();
                lineMap.put("LineNo", measSn);
                lineMap.put("Status", measSnToStatusMap.get(measSn) ? 1 : 0);
                lines.add(lineMap);
            }
        }
        params.put("Device", switchLineStatusUpdateRequest.getUpcommLogicAddr());
        params.put("Lines", lines);
        mqttGateway.sendToMqtt(JsonConvertUtils.convertToString(params).getBytes(), "/b03b99VXEV1/" + switchLineStatusUpdateRequest.getUpcommLogicAddr() + "/status/update", 0);
        return R.ok();

    }

}
