package com.gaea.iesms.bm.mqttHandler.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.gateway.MqttGateway;
import com.gaea.iesms.bm.mqttHandler.util.DispersionRateUtil;
import com.gaea.iesms.bm.mqttHandler.util.MeasitemcodeProp;
import com.gaea.iesms.core.feign.request.alarm.SoeRecordOnOffAlarmRequest;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteAlarmService;
import com.gaea.utils.ObjectUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import com.iesms.bizprocessors.common.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author Lin yicheng
 * @date 2022/3/14 10:36
 */
@Component
public class DingiotReceiveMessageHandler implements MessageHandler {

    @Value("${spring.mqtt.receiver.client-id}")
    private String receiverClientId;

    private static final String UPCOMM_PROTO = "MQTT_DINGIIOT";

    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(256, 256, 120, TimeUnit.SECONDS, new LinkedBlockingDeque<>(200), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    private static final Logger LOGGER = LoggerFactory.getLogger(DingiotReceiveMessageHandler.class);

    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();

    @Autowired
    private MeasitemcodeProp measitemcodeProp;

    @Autowired
    private DispersionRateUtil dispersionRateUtil;

    @Resource
    private GmDevTermService gmDevTermService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevTermServiceImpl")
    private GmopsDevTermService gmopsDevTermService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;

    @Resource
    private RemoteAlarmService remoteAlarmService;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private MqttGateway mqttGateway;


    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        try {
            if (ObjectUtil.isNotEmpty(message.getPayload())) {
                POOL.execute(new Thread(() -> {
                    handle(message);
                }));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final  static Map<String,String> typeMap = new HashMap();
    static {
        typeMap.put("heart","heart");
        typeMap.put("real","real");
        typeMap.put("change","change");
        typeMap.put("lastdata","lastdata");
    }

    private void handle(Message<?> message) {
        //获取报文的消息体
        String payload = (String) message.getPayload();
        //获取订阅主题
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");
        //获取服务质量等级
        int qos = (int) message.getHeaders().get("mqtt_receivedQos");
        //获取是否保留状态码
        boolean retained = (boolean) message.getHeaders().get("mqtt_receivedRetained");
        //获取是否复制状态码
        boolean duplicate = (boolean) message.getHeaders().get("mqtt_duplicate");
        //获取id
        UUID uuid = (UUID) message.getHeaders().get("id");
        String receivedMessageId = (uuid != null ? uuid.toString() : "");
        //将订阅主题按"/"进行分割，转成String数组
        String[] tpcs = StringUtils.split(topic, "/");
        //接入网关设备所属产品
        String upcommProductKey = tpcs[0];
        //获取时间戳
        Long receivedMessageTimestamp = (Long) message.getHeaders().get("timestamp");
        Long now = System.currentTimeMillis();

        List<Long> measPointIdList = new ArrayList<>();
        //有效数据Map
        Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap = Maps.newHashMap();
        //全部数据Map
        Map<Long, Map<String, Map<String, Object>>> batchTotalMeasDataInfosMap = Maps.newHashMap();
        Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();
        //转成json格式
        //转成json格式
        JSONObject payloadObj = JSONUtil.parseObj(payload);
        String sn = payloadObj.get("sn").toString();
        // 类型 real：实时上送 change--spont：变化数据上送 lastdata 补发上送 heart 心跳包
        String type = String.valueOf(payloadObj.get("type"));

        RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
        runAccessGatewayGetRequest.setProductKey(upcommProductKey);
        runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
        runAccessGatewayGetRequest.setUpcommLogicAddr(sn);

        //获取运行网关设备
        R<RunAccessGatewayGetResponse> runAccessGatewayR = dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
        RunAccessGatewayGetResponse runAccessGatewayGetResponse = runAccessGatewayR.getData();

        String org_no = "";
        if (ObjectUtils.isNotEmpty(runAccessGatewayGetResponse) && ObjectUtils.isNotEmpty(runAccessGatewayGetResponse.getRunAccessGateway()) &&
                CollectionUtil.isNotEmpty(runAccessGatewayGetResponse.getRunMeasPointList())) {
            //数据中心更新运行接入网关设备工况信息
            RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
            runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
            runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(now);
            runAccessGatewayOpsInfoUpdateRequest.setGmtMessageUp(now);
            runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(now);
            R<RunAccessGatewayNameAndDescUpdateResponse> runAccessGatewayNameAndDescUpdateResponseR = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
            //获取采集终端设备信息
            GmDevTermGetRequest gmDevTermGetRequest = new GmDevTermGetRequest();
            gmDevTermGetRequest.setAccessGatewayId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
            GmDevTermGetResponse gmDevTermGetResponse = gmDevTermService.getGmDevTerm(gmDevTermGetRequest);
            if (gmDevTermGetResponse.isSuccess()) {
                //更新采集终端设备工况信息
                GmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new GmopsDevTermRefreshRequest();
                gmopsDevTermRefreshRequest.setDevTermId(gmDevTermGetResponse.getGmDevTerm().getId());
                gmopsDevTermRefreshRequest.setGmtHeartbeatUp(now);
                gmopsDevTermRefreshRequest.setGmtMessageUp(now);
                gmopsDevTermRefreshRequest.setGmtMeasdataUp(now);
                GmopsDevTermRefreshResponse gmopsDevTermRefreshResponse = gmopsDevTermService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("GmopsDevTermRefreshResponse : " + gmopsDevTermRefreshResponse);
                }

                org_no =gmDevTermGetResponse.getGmDevTerm().getOrgNo();
            }

            for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
                String measCommAddr = runMeasPointVo.getMeasCommAddr().trim();
                //key为接入网关设备所属产品#上行通讯规约#终端地址#量测通信地址，value为量测点标识，保存key与value的缓存存入gaeadcu11MeasPointIdReverseCache
                measPointIdReverseMap.put(Joiner.on("#").join(upcommProductKey, UPCOMM_PROTO, sn, measCommAddr), runMeasPointVo.getId());
            }
        }

        List<SoeRecordOnOffAlarmRequest> soeRecordOnOffAlarmDoList = new ArrayList<>();
        //获取上传报文中的数据
        JSONObject dataInfos = payloadObj.getJSONObject("data");

        if (ObjectUtil.isNotEmpty(dataInfos)) {
            for (String key : dataInfos.keySet()) {

                //存放有效数据
                Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
                //存放全部数据
                Map<String, Map<String, Object>> insideTotalMap = Maps.newHashMap();
                Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(upcommProductKey, UPCOMM_PROTO, sn, key));
                if (measPointId != null) {
                    measPointIdList.add(measPointId);
                    RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
                    runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
                    runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(now);
                    runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(now);
                    R<RunMeasPointOpsInfoUpdateResponse> runMeasPointOpsInfoUpdateResponse = dataCenterCommonService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
                    JSONArray array = dataInfos.getJSONArray(key);
                    //用Iterator迭代器进行遍历
                    if (ArrayUtil.isNotEmpty(array)) {
                        Iterator<Object> it = array.iterator();
                        while (it.hasNext()) {
                            JSONObject ob = (JSONObject) it.next();
                            String modelCode = ob.get("id").toString();
                            BigDecimal value = BigDecimal.ZERO;
                            try {
                                value = NumberUtil.toBigDecimal(ObjectUtil.isNotEmpty(ob.get("value")) ? ob.get("value").toString() : "0");
                            }catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            //判断遥信信号
                            if("1".equals(ob.get("quality").toString()) && StringUtils.startsWithIgnoreCase(modelCode, "YX")){
                                String modelCode01 = modelCode + "01";
                                String abnormalItemCode = null;
                                String soeTitle = null;
                                try {
                                    abnormalItemCode = measitemcodeProp.getMeasitemCodeFromProperties(modelCode,topic);
                                } catch (IOException e) {
                                    LOGGER.error(">>>>>>>>>>>>>>>匹配异常项编码失败");
                                }
                                if (StrUtil.isEmpty(abnormalItemCode)) {
                                    continue;
                                }
                                try {
                                    soeTitle = measitemcodeProp.getMeasitemCodeFromProperties(modelCode,topic);
                                } catch (IOException e) {
                                    LOGGER.error(">>>>>>>>>>>>>>>匹配告警类型失败");
                                }
                                boolean onOff = ob.getInt("value") == 1;
                                SoeRecordOnOffAlarmRequest onOffAlarmDo = new SoeRecordOnOffAlarmRequest();
                                //严重等级 1 - 轻微；2 - 普通；3 - 严重
                                if ("YX4".equals(modelCode) || "YX7".equals(modelCode) || "YX27".equals(modelCode) || "YX29".equals(modelCode) || "YX30".equals(modelCode)) {
                                    onOffAlarmDo.setGraveLevel(2);
                                }else {
                                    onOffAlarmDo.setGraveLevel(3);
                                }
                                onOffAlarmDo.setSoeSortNo(abnormalItemCode);
                                onOffAlarmDo.setSoeTitle(soeTitle);
                                onOffAlarmDo.setSoeDesc(soeTitle);
                                onOffAlarmDo.setOnOff(onOff);
                                onOffAlarmDo.setDevMeterCommAddr(key);
                                onOffAlarmDo.setDevTermCommAddr(sn);
                                onOffAlarmDo.setMeasPointId(measPointId);
                                soeRecordOnOffAlarmDoList.add(onOffAlarmDo);
                            }
                            //获取全部数据
                            if(ObjectUtil.isNotEmpty(ob)) {
                                //存放全部数据
                                Map<String, Object> totalMeasDataInfo = Maps.newHashMap();
                                BigDecimal measDataValue = value;
                                //获取量测项编码
                                String measitemCode = null;
                                try {
                                    measitemCode = measitemcodeProp.getMeasitemCodeFromProperties(modelCode,topic);
                                } catch (IOException e) {
                                    e.printStackTrace();
                                }
                                if (StrUtil.isEmpty(measitemCode)) {
                                    continue;
                                }
                                totalMeasDataInfo.put("measDataValue", measDataValue);
                                insideTotalMap.put(measitemCode,totalMeasDataInfo);
                            }
                            //获取有效数据
                            if ("1".equals(ob.get("quality").toString()) && value.compareTo(BigDecimal.ZERO) > 0 ) {
                                if ("P".equals(ob.get("id")) && value.compareTo(new BigDecimal("3000")) > 0) {
                                    continue;
                                }
                                //存放有效数据
                                Map<String, Object> measDataInfo = Maps.newHashMap();
                                BigDecimal measDataValue = value;
                                //获取量测项编码
                                String measitemCode = null;
                                try {
                                    measitemCode = measitemcodeProp.getMeasitemCodeFromProperties(modelCode,topic);
                                } catch (IOException e) {
                                    LOGGER.error(">>>>>>>>>>>>>>>匹配量测项编码失败");
                                }
                                if (StrUtil.isEmpty(measitemCode)) {
                                    continue;
                                }
                                measDataInfo.put("pointId", measPointId);
                                measDataInfo.put("measItemCode", measitemCode);
                                measDataInfo.put("measDataClass", measDataValue.getClass());
                                measDataInfo.put("quality", Integer.parseInt(ob.get("quality").toString()));
                                measDataInfo.put("measDataValue", measDataValue);
                                measDataInfo.put("measDataSource", 0);
                                measDataInfo.put("gmtMeasDataLatest", receivedMessageTimestamp);
                                insideMap.put(measitemCode, measDataInfo);
                            }
                        }
                    }
                    if (MapUtil.isNotEmpty(insideTotalMap)) {
                        batchTotalMeasDataInfosMap.put(measPointId, insideTotalMap);
                    }
                    if (MapUtil.isNotEmpty(insideMap)) {
                        batchMeasDataInfosMap.put(measPointId.toString(), insideMap);
                    }
                }
            }
        }


        //处理表计不存在的数据
        if (ObjectUtil.isNotEmpty(dataInfos)){
            //获取原存在表计
            R<RunMeasPointListResponse> runMeasPointListResponseR=dataCenterCommonService.getRunMeasPointListBySn(sn);
            RunMeasPointListResponse runMeasPointListResponse = runMeasPointListResponseR.getData();
            List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
            List<String> measCommAddrList=runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
            for (String key : dataInfos.keySet()) {
                //若不存在上报表计 则插入相应实体模型
                if (!measCommAddrList.contains(key)) {
                    R<?> r = dataCenterCommonService.brushMeter(sn, key, topic);
                    if (r.isSuccess()){
                        LOGGER.info("===================终端" + sn + "表计地址" + key+"插入成功！！！");
                    }
                }
            }
        }


        if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
            //数据中心批量更新数据
            dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
            //数据中心批量更新量测点工况信息
            RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest = new RunMeasPointOpsInfoBatchUpdateRequest();
            runMeasPointOpsInfoBatchUpdateRequest.setMeasPointIdList(Lists.newArrayList());
            runMeasPointOpsInfoBatchUpdateRequest.setGmtMessageUp(now);
            runMeasPointOpsInfoBatchUpdateRequest.setGmtMeasdataUp(now);
            R<RunMeasPointOpsInfoBatchUpdateResponse> runMeasPointOpsInfoBatchUpdateResponse = dataCenterCommonService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
        }

        if (MapUtil.isNotEmpty(batchTotalMeasDataInfosMap)) {
            //更新量测表计设备工况
            for (Long measPointId : batchTotalMeasDataInfosMap.keySet()) {
                Map<String, Map<String, Object>> insideMap1 = batchTotalMeasDataInfosMap.get(measPointId);
                GmDevMeterGetRequest gmDevMeterGetRequest = new GmDevMeterGetRequest();
                gmDevMeterGetRequest.setMeasPointId(measPointId);
                GmDevMeterGetResponse gmDevMeterGetResponse = gmDevMeterService.getGmDevMeter(gmDevMeterGetRequest);
                GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
                if (gmDevMeterGetResponse.isSuccess()) {
                    gmopsDevMeterRefreshRequest = new GmopsDevMeterRefreshRequest();
                    gmopsDevMeterRefreshRequest.setDevMeterId(gmDevMeterGetResponse.getGmDevMeter().getId());
                    gmopsDevMeterRefreshRequest.setGmtMessageUp(now);
                    gmopsDevMeterRefreshRequest.setGmtMeasdataUp(now);
                    Map<String, Object> measDataInfoSetMap = Maps.newHashMap();
                    for (String measItemCode : insideMap1.keySet()) {
                        Map<String, Object> measDataInfo1 = insideMap1.get(measItemCode);
                        gmopsDevMeterRefreshRequest.setGmtReadingUp(now);
                        measDataInfoSetMap.put(measItemCode, measDataInfo1.get("measDataValue"));
                    }
                    gmopsDevMeterRefreshRequest.setMeasDataInfoSet(JsonConvertUtils.convertToString(measDataInfoSetMap));
                }
                if (ObjectUtil.isNotEmpty(gmopsDevMeterRefreshRequest)) {
                    GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = gmopsDevMeterService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
                }
            }
        }
        //批量新增或修改告警
        if (CollectionUtil.isNotEmpty(soeRecordOnOffAlarmDoList)) {
            remoteAlarmService.dataCenterDevMeterAlarm(soeRecordOnOffAlarmDoList);

        }

        //计算离散率
        Set<String> measItemCodeSet = new HashSet<String>();
        for (int i = 1; i < 21 ; i++) {
            measItemCodeSet.add("gen_watt_ipv" + i);
        }
        Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap1 = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(measPointIdList)) {
            measPointIdList.forEach(pointId -> {
                Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
                List<BigDecimal> list = new ArrayList<>();
                MeasDataLatestGetRequest measDataLatestGetRequest = new MeasDataLatestGetRequest();
                measDataLatestGetRequest.setMeasPointId(pointId);
                measDataLatestGetRequest.setMeasItemCodeSet(measItemCodeSet);
                measDataLatestGetRequest.setMeasDataSideType(1);
                R<MeasDataLatestGetResponse> responseR = dataCenterCommonService.getMeasDataLatest(measDataLatestGetRequest);
                MeasDataLatestGetResponse data = responseR.getData();
                if (ObjectUtil.isNotEmpty(data)) {
                    Map<String, MeasDataLatestInfo> map = data.getMeasDataMap();
                    measItemCodeSet.forEach(code -> {
                        MeasDataLatestInfo info = map.get(code);
                        if (ObjectUtil.isNotEmpty(info)) {
                            BigDecimal measValue = NumberUtil.toBigDecimal(info.getMeasDataValue().toString());
                            if (measValue.compareTo(BigDecimal.ZERO) > 0) {
                                list.add(measValue);
                            }
                        }
                    });
                    BigDecimal dispersionRate = dispersionRateUtil.calculate(list);
                    Map<String, Object> measDataInfo = Maps.newHashMap();
                    measDataInfo.put("pointId", pointId);
                    measDataInfo.put("measItemCode", "gen_watt_drivt");
                    measDataInfo.put("measDataClass", dispersionRate.getClass());
                    measDataInfo.put("quality", 1);
                    measDataInfo.put("measDataValue", dispersionRate);
                    measDataInfo.put("measDataSource", 0);
                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                    insideMap.put("gen_watt_drivt", measDataInfo);
                }
                batchMeasDataInfosMap1.put(pointId.toString(), insideMap);
            });
        }
        if (MapUtil.isNotEmpty(batchMeasDataInfosMap1)) {
            //数据中心批量更新数据
            dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap1);
        }

        // 最后发送中新
        // 此处暂时写死，萧山的话直接推送到中新那边的mqtt 根据类型来推送
//                topic约定(上行)。
//                实时上送:///upload_pv/21101001/(snJ/real
//                变化数据上送/upload_pv/21101001/sn)/spont
//                补发上送:/upload_pv/21101001/sn)/lastdata
//                心跳包:/upload_pv/21101001/sn /heart
//                离线(遗言模式): /upload_pv/21101001/snJ/offline
        String send_type = typeMap.get(type);
        if("120000002902".equals(org_no) && send_type != null){
            // 转换成萧山中新那边的规约信息
            String send_topic = "/upload_pv/211010001/"+ sn + "/" + send_type;
            LOGGER.info("发送的topic为：" + send_topic);
            mqttGateway.sendToMqtt(send_topic,payload);
        }
    }
}
