package com.gaea.iesms.bm.mqttHandler.handler;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.constant.DevLifeStateEnum;
import com.easesource.iot.datacenter.openservice.constant.DevRunStatusEnum;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.model.jsondto.*;
import com.gaea.iesms.bm.mqttHandler.model.request.JalaMqttSubscriptionsGetRequest;
import com.gaea.iesms.bm.mqttHandler.model.response.JalaMqttSubscriptionsGetResponse;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteAlarmService;
import com.gaea.iesms.core.model.entity.datacenter.*;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import com.iesms.bizprocessors.common.service.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

import javax.annotation.Nonnull;
import javax.annotation.Resource;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * @author Nick Zhang
 * @date 2019-03-11
 */
@Component
public class JalasmartReceiveMessageHandler implements MessageHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(JalasmartReceiveMessageHandler.class);

    private static final List<ListenableFuture<Integer>> FUTURES = Lists.newArrayList();
    private static final ListeningExecutorService EXECUTOR_SERVICE = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(256));

    private static final String UPCOMM_PROTO = "MQTT_JALASMART";
    private static final String INIT_ORG_NO = "12";         // 12 综合能源服务管理系统
    private final Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();


    @Resource
    private GmDevTermService gmDevTermService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevTermServiceImpl")
    private GmopsDevTermService gmopsDevTermService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;

    @Resource
    private SoeRecordOnOffAlarmService soeRecordOnOffAlarmService;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private RemoteAlarmService remoteAlarmService;

    @Override
    public void handleMessage(@Nonnull Message<?> message) throws MessagingException {
        //获取报文的消息体
        Object payload = message.getPayload();
        byte[] payloadBytes;
        if (payload instanceof String) {
            payloadBytes = ((String) payload).getBytes(Charset.forName("GBK"));
        } else {
            payloadBytes = (byte[]) payload;
        }
        //获取订阅主题
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");
        //获取服务质量等级
        int qos = (int) message.getHeaders().get("mqtt_receivedQos");
        //获取是否保留状态码
        boolean retained = (boolean) message.getHeaders().get("mqtt_receivedRetained");
        //获取是否复制状态码
        boolean duplicate = (boolean) message.getHeaders().get("mqtt_duplicate");
        String receivedProductKey = "";
        String receivedClientId = "";
        String receivedControllerId = "";
        String type = "";
        UUID uuid = (UUID) message.getHeaders().get("id");
        String receivedMessageId = (uuid != null ? uuid.toString() : "");
        Long receivedMessageTimestamp = (Long) message.getHeaders().get("timestamp");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("   time            : " + System.currentTimeMillis());
            LOGGER.debug("   Message         : " + JsonConvertUtils.convertToString(message));
            LOGGER.debug("   MessageHeaders  : " + JsonConvertUtils.convertToString(message.getHeaders()));
            LOGGER.debug("   topic           : " + topic);
        }
        //将订阅主题按"/"进行分割，转成String数组
        String[] tpcs = StringUtils.split(topic, "/");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("   tpcs            : " + JsonConvertUtils.convertToString(tpcs));
        }
        //判断订阅主题是否由三个部分以上组成
        if (tpcs != null && tpcs.length >= 3) {
            //订阅主题第一部分是接收消息设备所属产品类型，第二部分是接收消息客户端标识，第三部分是
            receivedProductKey = tpcs[0];
            receivedClientId = tpcs[1];
            receivedControllerId = tpcs[1];
            type = tpcs[2];

            try {
                FUTURES.add(EXECUTOR_SERVICE.submit(new HandleTask(payloadBytes, topic, qos, retained, duplicate, receivedProductKey, receivedClientId, receivedMessageId, receivedMessageTimestamp, receivedControllerId, type)));
            }
            catch(Exception e) {
                LOGGER.error(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    /**
     * 内部类
     */
    class HandleTask implements Callable<Integer> {
        private byte[] payloadBytes;

        private String topic;

        private int qos;

        private boolean retained;

        private boolean duplicate;

        private String receivedProductKey;
        private String receivedClientId;
        private String receivedMessageId;
        private Long receivedMessageTimestamp;

        private String receivedControllerId;

        private String type;

        public HandleTask(byte[] payloadBytes, String topic, int qos, boolean retained, boolean duplicate, String receivedProductKey, String receivedClientId, String receivedMessageId, Long receivedMessageTimestamp, String receivedControllerId, String type) {
            this.payloadBytes = payloadBytes;
            this.topic = topic;
            this.qos = qos;
            this.retained = retained;
            this.duplicate = duplicate;
            this.receivedProductKey = receivedProductKey;
            this.receivedClientId = receivedClientId;
            this.receivedMessageId = receivedMessageId;
            this.receivedMessageTimestamp = receivedMessageTimestamp;
            this.receivedControllerId = receivedControllerId;
            this.type = type;
        }

        @Override
        public Integer call() throws Exception {

            try {

                RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
                runAccessGatewayGetRequest.setProductKey(receivedProductKey);
                runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
                runAccessGatewayGetRequest.setUpcommLogicAddr(receivedControllerId);
                //获取运行网关设备
                R<RunAccessGatewayGetResponse> runAccessGateway = dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
                RunAccessGatewayGetResponse runAccessGatewayGetResponse = runAccessGateway.getData();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" runAccessGatewayGetResponse   : " + JsonConvertUtils.convertToString(runAccessGatewayGetResponse));
                }
                if (runAccessGatewayGetResponse != null && runAccessGatewayGetResponse.getRunMeasPointList() != null) {
                    for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
                        measPointIdReverseMap.put(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, runMeasPointVo.getMeasSn()), runMeasPointVo.getId());
                    }
                }

                RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
                runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse != null && runAccessGatewayGetResponse.getRunAccessGateway() != null ? runAccessGatewayGetResponse.getRunAccessGateway().getId() : 0L);
                runAccessGatewayOpsInfoUpdateRequest.setGmtConnectedAt(System.currentTimeMillis());
                runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(System.currentTimeMillis());
                runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                if (StringUtils.equalsIgnoreCase(type, "device")) {
                    GatewayDeviceMqttJsonDto gatewayDeviceMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayDeviceMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayDeviceMqttJsonDto          : " + JsonConvertUtils.convertToString(gatewayDeviceMqttJsonDto));
                    }
                    RegisteredDevAccessGatewayGetRequest getRequest = new RegisteredDevAccessGatewayGetRequest();
                    getRequest.setProductKey(receivedProductKey);
                    getRequest.setUpcommProto(UPCOMM_PROTO);
                    getRequest.setUpcommLogicAddr(gatewayDeviceMqttJsonDto.getControllerId());
                    R<RegisteredDevAccessGatewayGetResponse> registeredDevAccessGateway = dataCenterCommonService.getRegisteredDevAccessGateway(getRequest);
                    RegisteredDevAccessGatewayGetResponse getResponse = registeredDevAccessGateway.getData();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" getResponse : " + JsonConvertUtils.convertToString(getResponse));
                    }
                    if (getResponse.isSuccess() && getResponse.getDevAccessGateway() != null) {
                        // TODO　已有注册网关
                    } else {
                        // TODO　未有注册网关，需注册
//                        JalaMqttSubscriptionsGetRequest jalaMqttSubscriptionsGetRequest = new JalaMqttSubscriptionsGetRequest();
//                        jalaMqttSubscriptionsGetRequest.setProductKey(receivedProductKey);
//                        jalaMqttSubscriptionsGetRequest.setUpcommLogicAddr(gatewayDeviceMqttJsonDto.getControllerId());
//                        JalaMqttSubscriptionsGetResponse jalaMqttSubscriptionsGetResponse = jalaMqttSubscriptionsService.getJalaMqttSubscriptions(jalaMqttSubscriptionsGetRequest);
                            NewDevAccessGatewayRegisterRequest newDevAccessGatewayRegisterRequest = new NewDevAccessGatewayRegisterRequest();
                            DevAccessDo devAccessGatewayParent = new DevAccessDo();
                            devAccessGatewayParent.setOrgNo(INIT_ORG_NO);
                            devAccessGatewayParent.setDevAccessSortNo("JALASMART_GATEWAY");
                            devAccessGatewayParent.setDevAccessNo(gatewayDeviceMqttJsonDto.getControllerId());
                            devAccessGatewayParent.setDevAccessName(devAccessGatewayParent.getDevAccessNo());
                            Map<String, Object> devAccessDetail = Maps.newHashMap();
                            devAccessDetail.put("lan", StringUtils.upperCase(gatewayDeviceMqttJsonDto.getLan()));
                            devAccessGatewayParent.setDevAccessDetail(JsonConvertUtils.convertToString(devAccessDetail));
                            devAccessGatewayParent.setGateway(true);
                            devAccessGatewayParent.setTrunking(false);
                            devAccessGatewayParent.setMeasure(false);
                            devAccessGatewayParent.setLifeState(DevLifeStateEnum.RUNNING.getCode());
                            devAccessGatewayParent.setMfrCode("JALASMART");
                            devAccessGatewayParent.setModelCode("");
                            devAccessGatewayParent.setSortSn(1);
                            devAccessGatewayParent.setValid(true);
                            devAccessGatewayParent.setGmtCreate(System.currentTimeMillis());
                            devAccessGatewayParent.setGmtModified(System.currentTimeMillis());
                            devAccessGatewayParent.setGmtInvalid(0L);
                            devAccessGatewayParent.setVersion(1);
                            DevAccessGatewayDo devAccessGatewayDo = new DevAccessGatewayDo();
                            devAccessGatewayDo.setUpcommProto(getRequest.getUpcommProto());
                            devAccessGatewayDo.setUpcommProtoVer("1.6");
                            devAccessGatewayDo.setUpcommLogicAddr(getRequest.getUpcommLogicAddr());
                            devAccessGatewayDo.setEncrypt(false);
                            devAccessGatewayDo.setVersion(1);
                            RunAccessGatewayDo runAccessGatewayDo = new RunAccessGatewayDo();
                            runAccessGatewayDo.setOrgNo(devAccessGatewayParent.getOrgNo());
                            runAccessGatewayDo.setProductKey(receivedProductKey);
                            runAccessGatewayDo.setClientId(gatewayDeviceMqttJsonDto.getControllerId());
                            runAccessGatewayDo.setUpcommProto(devAccessGatewayDo.getUpcommProto());
                            runAccessGatewayDo.setUpcommProtoVer(devAccessGatewayDo.getUpcommProtoVer());
                            runAccessGatewayDo.setUpcommLogicAddr(devAccessGatewayDo.getUpcommLogicAddr());
                            runAccessGatewayDo.setCascade(false);
                            runAccessGatewayDo.setParentId(0L);
                            runAccessGatewayDo.setEncrypt(false);
                            runAccessGatewayDo.setRunStatus(DevRunStatusEnum.GOTORUN.getStatus());
                            runAccessGatewayDo.setMeasPointCount(0);
                            runAccessGatewayDo.setOnline(true);
                            runAccessGatewayDo.setGmtConnectedAt(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtHeartbeatUp(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtMessageUp(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtMeasdataUp(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtAlarmUp(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtCreate(System.currentTimeMillis());
                            runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                            runAccessGatewayDo.setVersion(1);
                            List<DevAccessDo> devAccessMeasureParentList = Lists.newArrayList();
                            List<DevAccessMeasureDo> devAccessMeasureDoList = Lists.newArrayList();
                            List<RunMeasPointDo> runMeasPointDoList = Lists.newArrayList();
                            if (gatewayDeviceMqttJsonDto.getLines().size() > 0) {
                                runAccessGatewayDo.setMeasPointCount(gatewayDeviceMqttJsonDto.getLines().size());
                                for (GatewayDeviceLineMqttJsonDto gatewayDeviceLineMqttJsonDto : gatewayDeviceMqttJsonDto.getLines()) {
                                    DevAccessDo devAccessMeasureParent = new DevAccessDo();
                                    devAccessMeasureParent.setOrgNo(devAccessGatewayParent.getOrgNo());
                                    devAccessMeasureParent.setDevAccessSortNo("JALASMART_SWITCH");
                                    devAccessMeasureParent.setDevAccessNo(gatewayDeviceLineMqttJsonDto.getLineId());
                                    devAccessMeasureParent.setDevAccessName("线路" + gatewayDeviceLineMqttJsonDto.getLineNo());
                                    devAccessMeasureParent.setDevAccessDesc("线路" + gatewayDeviceLineMqttJsonDto.getLineNo());
                                    devAccessMeasureParent.setGateway(false);
                                    devAccessMeasureParent.setTrunking(false);
                                    devAccessMeasureParent.setMeasure(true);
                                    devAccessMeasureParent.setLifeState(DevLifeStateEnum.RUNNING.getCode());
                                    devAccessMeasureParent.setMfrCode("JALASMART");
                                    devAccessMeasureParent.setModelCode(gatewayDeviceLineMqttJsonDto.getModel());
                                    devAccessMeasureParent.setSortSn(1);
                                    devAccessMeasureParent.setValid(true);
                                    devAccessMeasureParent.setGmtCreate(System.currentTimeMillis());
                                    devAccessMeasureParent.setGmtModified(System.currentTimeMillis());
                                    devAccessMeasureParent.setGmtInvalid(0L);
                                    devAccessMeasureParent.setVersion(1);
                                    DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
                                    devAccessMeasureDo.setMeasCommMode("RS485");
                                    devAccessMeasureDo.setMeasCommProto("JALASMART_SWITCH");
                                    devAccessMeasureDo.setMeasCommAddr("" + gatewayDeviceLineMqttJsonDto.getLineNo());
                                    devAccessMeasureDo.setEnableElec(true);
                                    devAccessMeasureDo.setElecPhaseCount(StringUtils.startsWith(gatewayDeviceLineMqttJsonDto.getModel(), "3P") ? 3 : 1);
                                    devAccessMeasureDo.setEnableWater(false);
                                    devAccessMeasureDo.setEnableGas(false);
                                    devAccessMeasureDo.setEnableHeat(false);
                                    devAccessMeasureDo.setVersion(1);
                                    devAccessMeasureParentList.add(devAccessMeasureParent);
                                    devAccessMeasureDoList.add(devAccessMeasureDo);
                                }
                            }
                            newDevAccessGatewayRegisterRequest.setDevAccessGatewayParent(devAccessGatewayParent);
                            newDevAccessGatewayRegisterRequest.setDevAccessGatewayDo(devAccessGatewayDo);
                            newDevAccessGatewayRegisterRequest.setRunAccessGatewayDo(runAccessGatewayDo);
                            newDevAccessGatewayRegisterRequest.setDevAccessMeasureParentList(devAccessMeasureParentList);
                            newDevAccessGatewayRegisterRequest.setDevAccessMeasureDoList(devAccessMeasureDoList);
                            newDevAccessGatewayRegisterRequest.setRunMeasPointDoList(runMeasPointDoList);
                            //注册网关
                            R<NewDevAccessGatewayRegisterResponse> r = dataCenterCommonService.registerNewDevAccessGateway(newDevAccessGatewayRegisterRequest);
                            NewDevAccessGatewayRegisterResponse newDevAccessGatewayRegisterResponse =  r.getData();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("NewDevAccessGatewayRegisterResponse : " + JsonConvertUtils.convertToString(newDevAccessGatewayRegisterResponse));
                            }
                        }

                } else if (StringUtils.equalsIgnoreCase(type, "parameter")) {
                    GatewayParameterMqttJsonDto gatewayParameterMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayParameterMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayParameterMqttJsonDto       : " + JsonConvertUtils.convertToString(gatewayParameterMqttJsonDto));
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "parameter_3")) {
                    GatewayParameter3MqttJsonDto gatewayParameter3MqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayParameter3MqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayParameter3MqttJsonDto      : " + JsonConvertUtils.convertToString(gatewayParameter3MqttJsonDto));
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "power")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayPowerMqttJsonDto gatewayPowerMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayPowerMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayPowerMqttJsonDto           : " + JsonConvertUtils.convertToString(gatewayPowerMqttJsonDto));
                    }
                    if (gatewayPowerMqttJsonDto != null && gatewayPowerMqttJsonDto.getLines() != null) {
                        for (GatewayPowerLineMqttJsonDto jsonDto : gatewayPowerMqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getVoltage() != null) {
                                    Map<String, Object> measDataInfoVoltage = Maps.newHashMap();
                                    measDataInfoVoltage.put("measItemCode", "gen_watt_ua");
                                    measDataInfoVoltage.put("measDataClass", jsonDto.getVoltage().getClass());
                                    measDataInfoVoltage.put("measDataValue", jsonDto.getVoltage());
                                    measDataInfoVoltage.put("measDataSource", 0);
                                    measDataInfoVoltage.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoVoltage));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoVoltage.get("measItemCode"), measDataInfoVoltage);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                                if (jsonDto.getCurrent() != null) {
                                    Map<String, Object> measDataInfoCurrent = Maps.newHashMap();
                                    measDataInfoCurrent.put("measItemCode", "gen_watt_ia");
                                    measDataInfoCurrent.put("measDataClass", jsonDto.getCurrent().getClass());
                                    measDataInfoCurrent.put("measDataValue", jsonDto.getCurrent());
                                    measDataInfoCurrent.put("measDataSource", 0);
                                    measDataInfoCurrent.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoCurrent));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoCurrent.get("measItemCode"), measDataInfoCurrent);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getPower() != null) {
                                    Map<String, Object> measDataInfoPower = Maps.newHashMap();
                                    measDataInfoPower.put("measItemCode", "gen_watt_acpt");
                                    measDataInfoPower.put("measDataClass", jsonDto.getPower().getClass());
                                    measDataInfoPower.put("measDataValue", jsonDto.getPower().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfoPower.put("measDataSource", 0);
                                    measDataInfoPower.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoPower));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoPower.get("measItemCode"), measDataInfoPower);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "power3")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayPower3MqttJsonDto gatewayPower3MqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayPower3MqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayPower3MqttJsonDto          : " + JsonConvertUtils.convertToString(gatewayPower3MqttJsonDto));
                    }
                    if (gatewayPower3MqttJsonDto != null && gatewayPower3MqttJsonDto.getLines() != null) {
                        for (GatewayPower3LineMqttJsonDto jsonDto : gatewayPower3MqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getCurrentA() != null) {
                                    Map<String, Object> measDataInfoCurrentA = Maps.newHashMap();
                                    measDataInfoCurrentA.put("measItemCode", "gen_watt_ia");
                                    measDataInfoCurrentA.put("measDataClass", jsonDto.getCurrentA().getClass());
                                    measDataInfoCurrentA.put("measDataValue", jsonDto.getCurrentA());
                                    measDataInfoCurrentA.put("measDataSource", 0);
                                    measDataInfoCurrentA.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoCurrentA));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoCurrentA.get("measItemCode"), measDataInfoCurrentA);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getCurrentB() != null) {
                                    Map<String, Object> measDataInfoCurrentB = Maps.newHashMap();
                                    measDataInfoCurrentB.put("measItemCode", "gen_watt_ib");
                                    measDataInfoCurrentB.put("measDataClass", jsonDto.getCurrentB().getClass());
                                    measDataInfoCurrentB.put("measDataValue", jsonDto.getCurrentB());
                                    measDataInfoCurrentB.put("measDataSource", 0);
                                    measDataInfoCurrentB.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoCurrentB));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoCurrentB.get("measItemCode"), measDataInfoCurrentB);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getCurrentC() != null) {
                                    Map<String, Object> measDataInfoCurrentC = Maps.newHashMap();
                                    measDataInfoCurrentC.put("measItemCode", "gen_watt_ic");
                                    measDataInfoCurrentC.put("measDataClass", jsonDto.getCurrentC().getClass());
                                    measDataInfoCurrentC.put("measDataValue", jsonDto.getCurrentC());
                                    measDataInfoCurrentC.put("measDataSource", 0);
                                    measDataInfoCurrentC.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoCurrentC));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoCurrentC.get("measItemCode"), measDataInfoCurrentC);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getVoltageAb() != null) {
                                    Map<String, Object> measDataInfoVoltageAb = Maps.newHashMap();
                                    measDataInfoVoltageAb.put("measItemCode", "gen_watt_ua");
                                    measDataInfoVoltageAb.put("measDataClass", jsonDto.getVoltageAb().getClass());
                                    measDataInfoVoltageAb.put("measDataValue", jsonDto.getVoltageAb());
                                    measDataInfoVoltageAb.put("measDataSource", 0);
                                    measDataInfoVoltageAb.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoVoltageAb));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoVoltageAb.get("measItemCode"), measDataInfoVoltageAb);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getVoltageBc() != null) {
                                    Map<String, Object> measDataInfoVoltageBc = Maps.newHashMap();
                                    measDataInfoVoltageBc.put("measItemCode", "gen_watt_ub");
                                    measDataInfoVoltageBc.put("measDataClass", jsonDto.getVoltageBc().getClass());
                                    measDataInfoVoltageBc.put("measDataValue", jsonDto.getVoltageBc());
                                    measDataInfoVoltageBc.put("measDataSource", 0);
                                    measDataInfoVoltageBc.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoVoltageBc));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoVoltageBc.get("measItemCode"), measDataInfoVoltageBc);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getVoltageCa() != null) {
                                    Map<String, Object> measDataInfoVoltageCa = Maps.newHashMap();
                                    measDataInfoVoltageCa.put("measItemCode", "gen_watt_uc");
                                    measDataInfoVoltageCa.put("measDataClass", jsonDto.getVoltageCa().getClass());
                                    measDataInfoVoltageCa.put("measDataValue", jsonDto.getVoltageCa());
                                    measDataInfoVoltageCa.put("measDataSource", 0);
                                    measDataInfoVoltageCa.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoVoltageCa));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoVoltageCa.get("measItemCode"), measDataInfoVoltageCa);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getLeakage() != null) {
                                    Map<String, Object> measDataInfoLeakage = Maps.newHashMap();
                                    measDataInfoLeakage.put("measItemCode", "gen_watt_il");
                                    measDataInfoLeakage.put("measDataClass", jsonDto.getLeakage().getClass());
                                    measDataInfoLeakage.put("measDataValue", jsonDto.getLeakage());
                                    measDataInfoLeakage.put("measDataSource", 0);
                                    measDataInfoLeakage.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoLeakage));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoLeakage.get("measItemCode"), measDataInfoLeakage);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getPower() != null) {
                                    Map<String, Object> measDataInfoPower = Maps.newHashMap();
                                    measDataInfoPower.put("measItemCode", "gen_watt_acpt");
                                    measDataInfoPower.put("measDataClass", jsonDto.getPower().getClass());
                                    measDataInfoPower.put("measDataValue", jsonDto.getPower().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfoPower.put("measDataSource", 0);
                                    measDataInfoPower.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoPower));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoPower.get("measItemCode"), measDataInfoPower);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getPowerA() != null) {
                                    Map<String, Object> measDataInfoPowerA = Maps.newHashMap();
                                    measDataInfoPowerA.put("measItemCode", "gen_watt_acpa");
                                    measDataInfoPowerA.put("measDataClass", jsonDto.getPowerA().getClass());
                                    measDataInfoPowerA.put("measDataValue", jsonDto.getPowerA().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfoPowerA.put("measDataSource", 0);
                                    measDataInfoPowerA.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoPowerA));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoPowerA.get("measItemCode"), measDataInfoPowerA);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getPowerB() != null) {
                                    Map<String, Object> measDataInfoPowerB = Maps.newHashMap();
                                    measDataInfoPowerB.put("measItemCode", "gen_watt_acpb");
                                    measDataInfoPowerB.put("measDataClass", jsonDto.getPowerB().getClass());
                                    measDataInfoPowerB.put("measDataValue", jsonDto.getPowerB().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfoPowerB.put("measDataSource", 0);
                                    measDataInfoPowerB.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoPowerB));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoPowerB.get("measItemCode"), measDataInfoPowerB);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getPowerC() != null) {
                                    Map<String, Object> measDataInfoPowerC = Maps.newHashMap();
                                    measDataInfoPowerC.put("measItemCode", "gen_watt_acpc");
                                    measDataInfoPowerC.put("measDataClass", jsonDto.getPowerC().getClass());
                                    measDataInfoPowerC.put("measDataValue", jsonDto.getPowerC().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfoPowerC.put("measDataSource", 0);
                                    measDataInfoPowerC.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoPowerC));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoPowerC.get("measItemCode"), measDataInfoPowerC);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "temp")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayTempMqttJsonDto gatewayTempMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayTempMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayTempMqttJsonDto            : " + JsonConvertUtils.convertToString(gatewayTempMqttJsonDto));
                    }
                    if (gatewayTempMqttJsonDto != null && gatewayTempMqttJsonDto.getLines() != null) {
                        for (GatewayTempLineMqttJsonDto jsonDto : gatewayTempMqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getTemp() != null) {
                                    Map<String, Object> measDataInfoTemp = Maps.newHashMap();
                                    measDataInfoTemp.put("measItemCode", "gen_watt_tempa");
                                    measDataInfoTemp.put("measDataClass", jsonDto.getTemp().getClass());
                                    measDataInfoTemp.put("measDataValue", jsonDto.getTemp());
                                    measDataInfoTemp.put("measDataSource", 0);
                                    measDataInfoTemp.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoTemp));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoTemp.get("measItemCode"), measDataInfoTemp);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "temp3")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayTemp3MqttJsonDto gatewayTemp3MqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayTemp3MqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayTemp3MqttJsonDto           : " + JsonConvertUtils.convertToString(gatewayTemp3MqttJsonDto));
                    }
                    if (gatewayTemp3MqttJsonDto != null && gatewayTemp3MqttJsonDto.getLines() != null) {
                        for (GatewayTemp3LineMqttJsonDto jsonDto : gatewayTemp3MqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getTempA() != null) {
                                    Map<String, Object> measDataInfoTempA = Maps.newHashMap();
                                    measDataInfoTempA.put("measItemCode", "gen_watt_tempa");
                                    measDataInfoTempA.put("measDataClass", jsonDto.getTempA().getClass());
                                    measDataInfoTempA.put("measDataValue", jsonDto.getTempA());
                                    measDataInfoTempA.put("measDataSource", 0);
                                    measDataInfoTempA.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoTempA));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoTempA.get("measItemCode"), measDataInfoTempA);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getTempB() != null) {
                                    Map<String, Object> measDataInfoTempB = Maps.newHashMap();
                                    measDataInfoTempB.put("measItemCode", "gen_watt_tempb");
                                    measDataInfoTempB.put("measDataClass", jsonDto.getTempB().getClass());
                                    measDataInfoTempB.put("measDataValue", jsonDto.getTempB());
                                    measDataInfoTempB.put("measDataSource", 0);
                                    measDataInfoTempB.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoTempB));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoTempB.get("measItemCode"), measDataInfoTempB);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getTempC() != null) {
                                    Map<String, Object> measDataInfoTempC = Maps.newHashMap();
                                    measDataInfoTempC.put("measItemCode", "gen_watt_tempc");
                                    measDataInfoTempC.put("measDataClass", jsonDto.getTempC().getClass());
                                    measDataInfoTempC.put("measDataValue", jsonDto.getTempC());
                                    measDataInfoTempC.put("measDataSource", 0);
                                    measDataInfoTempC.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoTempC));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoTempC.get("measItemCode"), measDataInfoTempC);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getTempN() != null) {
                                    Map<String, Object> measDataInfoTempN = Maps.newHashMap();
                                    measDataInfoTempN.put("measItemCode", "gen_watt_tempn");
                                    measDataInfoTempN.put("measDataClass", jsonDto.getTempN().getClass());
                                    measDataInfoTempN.put("measDataValue", jsonDto.getTempN());
                                    measDataInfoTempN.put("measDataSource", 0);
                                    measDataInfoTempN.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoTempN));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoTempN.get("measItemCode"), measDataInfoTempN);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "powqsf")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayPowqsfMqttJsonDto gatewayPowqsfMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayPowqsfMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayPowqsfMqttJsonDto          : " + JsonConvertUtils.convertToString(gatewayPowqsfMqttJsonDto));
                    }
                    if (gatewayPowqsfMqttJsonDto != null && gatewayPowqsfMqttJsonDto.getLines() != null) {
                        for (GatewayPowqsfLineMqttJsonDto jsonDto : gatewayPowqsfMqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getQowAll() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_rept");
                                    measDataInfo.put("measDataClass", jsonDto.getQowAll().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getQowAll().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getQowA() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_repa");
                                    measDataInfo.put("measDataClass", jsonDto.getQowA().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getQowA().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getQowB() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_repb");
                                    measDataInfo.put("measDataClass", jsonDto.getQowB().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getQowB().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getQowC() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_repc");
                                    measDataInfo.put("measDataClass", jsonDto.getQowC().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getQowC().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getSowAll() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_appt");
                                    measDataInfo.put("measDataClass", jsonDto.getSowAll().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getSowAll().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getSowA() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_appa");
                                    measDataInfo.put("measDataClass", jsonDto.getSowA().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getSowA().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getSowB() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_appb");
                                    measDataInfo.put("measDataClass", jsonDto.getSowB().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getSowB().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getSowC() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_appc");
                                    measDataInfo.put("measDataClass", jsonDto.getSowC().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getSowC().divide(new BigDecimal(1000.0D), 8, BigDecimal.ROUND_HALF_UP));
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getFacAll() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_pft");
                                    measDataInfo.put("measDataClass", jsonDto.getFacAll().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getFacAll());
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getFacA() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_pfa");
                                    measDataInfo.put("measDataClass", jsonDto.getFacA().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getFacA());
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getFacB() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_pfb");
                                    measDataInfo.put("measDataClass", jsonDto.getFacB().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getFacB());
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }

                                if (jsonDto.getFacC() != null) {
                                    Map<String, Object> measDataInfo = Maps.newHashMap();
                                    measDataInfo.put("measItemCode", "gen_watt_pfc");
                                    measDataInfo.put("measDataClass", jsonDto.getFacC().getClass());
                                    measDataInfo.put("measDataValue", jsonDto.getFacC());
                                    measDataInfo.put("measDataSource", 0);
                                    measDataInfo.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfo));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfo.get("measItemCode"), measDataInfo);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }

                } else if (StringUtils.equalsIgnoreCase(type, "leakage")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayLeakageMqttJsonDto gatewayLeakageMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayLeakageMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayLeakageMqttJsonDto         : " + JsonConvertUtils.convertToString(gatewayLeakageMqttJsonDto));
                    }
                    if (gatewayLeakageMqttJsonDto != null && gatewayLeakageMqttJsonDto.getLines() != null) {
                        for (GatewayLeakageLineMqttJsonDto jsonDto : gatewayLeakageMqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getCurrent() != null) {
                                    Map<String, Object> measDataInfoLeakage = Maps.newHashMap();
                                    measDataInfoLeakage.put("measItemCode", "gen_watt_il");
                                    measDataInfoLeakage.put("measDataClass", jsonDto.getCurrent().getClass());
                                    measDataInfoLeakage.put("measDataValue", jsonDto.getCurrent());
                                    measDataInfoLeakage.put("measDataSource", 0);
                                    measDataInfoLeakage.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoLeakage));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    updateGmopsDevMeter(measPointId, null);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoLeakage.get("measItemCode"), measDataInfoLeakage);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "energy")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    String changeStr = new String(payloadBytes, Charset.forName("GBK"));
                    if (changeStr.contains("[")) {
                        GatewayEnergyMqttJsonDto gatewayEnergyMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayEnergyMqttJsonDto.class, true);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" gatewayEnergyMqttJsonDto          : " + JsonConvertUtils.convertToString(gatewayEnergyMqttJsonDto));
                        }
                        if (gatewayEnergyMqttJsonDto != null && gatewayEnergyMqttJsonDto.getLines() != null) {
                            for (GatewayEnergyLineMqttJsonDto jsonDto : gatewayEnergyMqttJsonDto.getLines()) {
                                Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                                if (measPointId != null && measPointId > 0L) {
                                    if (jsonDto.getEnergy() != null) {
                                        Map<String, Object> measDataInfoEnergy = Maps.newHashMap();
                                        measDataInfoEnergy.put("measItemCode", "gen_watt_paet");
                                        measDataInfoEnergy.put("measDataClass", jsonDto.getEnergy().getClass());
                                        measDataInfoEnergy.put("measDataValue", jsonDto.getEnergy());
                                        measDataInfoEnergy.put("measDataSource", 0);
                                        measDataInfoEnergy.put("gmtMeasDataLatest", System.currentTimeMillis());
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoEnergy));
                                        }
                                        updateRunMeasPointOpsInfo(measPointId);
                                        updateGmopsDevMeter(measPointId, null);
                                        dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoEnergy.get("measItemCode"), measDataInfoEnergy);
                                        remoteAlarmService.dataCenterBoundSoeRecord();
                                    }
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "status")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
                    GatewayStatusMqttJsonDto gatewayStatusMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayStatusMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayStatusMqttJsonDto          : " + JsonConvertUtils.convertToString(gatewayStatusMqttJsonDto));
                    }
                    if (gatewayStatusMqttJsonDto != null && gatewayStatusMqttJsonDto.getLines() != null) {
                        for (GatewayStatusLineMqttJsonDto jsonDto : gatewayStatusMqttJsonDto.getLines()) {
                            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(receivedProductKey, UPCOMM_PROTO, receivedControllerId, jsonDto.getLineNo()));
                            if (measPointId != null && measPointId > 0L) {
                                if (jsonDto.getStatus() != null) {
                                    Map<String, Object> measDataInfoStatus = Maps.newHashMap();
                                    measDataInfoStatus.put("measItemCode", "gen_watt_state_open");
                                    measDataInfoStatus.put("measDataClass", Boolean.class);
                                    measDataInfoStatus.put("measDataValue", jsonDto.getStatus() == 1);
                                    measDataInfoStatus.put("measDataSource", 0);
                                    measDataInfoStatus.put("gmtMeasDataLatest", System.currentTimeMillis());
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(" measDataInfo  : " + JsonConvertUtils.convertToString(measDataInfoStatus));
                                    }
                                    updateRunMeasPointOpsInfo(measPointId);
                                    Map<String, Object> measDataInfoSet = Maps.newHashMap();
                                    measDataInfoSet.put("meter_state_open", jsonDto.getStatus());
                                    updateGmopsDevMeter(measPointId, measDataInfoSet);
                                    dataCenterCommonService.updateMeasDataLatest(measPointId, (String) measDataInfoStatus.get("measItemCode"), measDataInfoStatus);
                                    remoteAlarmService.dataCenterBoundSoeRecord();
                                    GatewayDeviceMqttJsonDto gatewayDeviceMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayDeviceMqttJsonDto.class, true);

                                    SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
                                    onOffAlarmDo.setOnOff(jsonDto.getStatus() == 1);
                                    onOffAlarmDo.setDevMeterCommAddr(gatewayDeviceMqttJsonDto.getControllerId());
                                    onOffAlarmDo.setMeasPointId(measPointId);
                                    soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);
                                }
                            }
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "message")) {
                    runAccessGatewayOpsInfoUpdateRequest.setGmtAlarmUp(System.currentTimeMillis());
                    GatewayMessageMqttJsonDto gatewayMessageMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayMessageMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayMessageMqttJsonDto         : " + JsonConvertUtils.convertToString(gatewayMessageMqttJsonDto));
                    }
                } else if (StringUtils.equalsIgnoreCase(type, "isLeakagetest")) {
                    GatewayIsLeakagetestMqttJsonDto gatewayIsLeakagetestMqttJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayIsLeakagetestMqttJsonDto.class, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" gatewayIsLeakagetestMqttJsonDto   : " + JsonConvertUtils.convertToString(gatewayIsLeakagetestMqttJsonDto));
                    }
                }

                //处理表计不存在的数据
                GatewayPowerMqttJsonDto reflashMeterRunMeasPointJsonDto = JsonConvertUtils.convertFromString(new String(payloadBytes, Charset.forName("GBK")), GatewayPowerMqttJsonDto.class, true);
                if (ObjectUtil.isNotEmpty(reflashMeterRunMeasPointJsonDto)&& CollectionUtil.isNotEmpty(reflashMeterRunMeasPointJsonDto.getLines())){
                    //获取原存在表计
                    R<RunMeasPointListResponse> runMeasPointListBySn = dataCenterCommonService.getRunMeasPointListBySn(receivedControllerId);
                    RunMeasPointListResponse runMeasPointListResponse= runMeasPointListBySn.getData();
                    List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
                    List<String> measCommAddrList=runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
                    for (GatewayPowerLineMqttJsonDto line : reflashMeterRunMeasPointJsonDto.getLines()) {
                        //若不存在上报表计 则插入相应实体模型
                        if (!measCommAddrList.contains(line.getLineNo().toString())) {
                            R flag = dataCenterCommonService.brushMeter(receivedControllerId, line.getLineNo().toString(), TopicEnum.JALASMART.getTopic());
                            if (flag.isSuccess()){
                                LOGGER.info("===================终端" + receivedControllerId + "表计地址" + line.getLineNo()+"插入成功！！！");
                            }
                        }
                    }
                }


                R runAccessGatewayOpsInfoUpdateResponse = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" runAccessGatewayOpsInfoUpdateResponse    : " + JsonConvertUtils.convertToString(runAccessGatewayOpsInfoUpdateResponse));
                }

                updateGmopsDevTerm(runAccessGatewayOpsInfoUpdateRequest.getDevAccessId());
            } catch (Exception e) {
                LOGGER.error(e.getMessage(), e.fillInStackTrace());
            }
            return 1;
        }


        private void updateRunMeasPointOpsInfo(Long measPointId) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   measPointId   : " + JsonConvertUtils.convertToString(measPointId));
            }
            RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
            runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
            runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(System.currentTimeMillis());
            runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
            R runMeasPointOpsInfoUpdateResponse = dataCenterCommonService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   runMeasPointOpsInfoUpdateResponse   : " + JsonConvertUtils.convertToString(runMeasPointOpsInfoUpdateResponse));
            }
        }

        private void updateGmopsDevTerm(Long devTermId) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   devTermId          : " + JsonConvertUtils.convertToString(devTermId));
            }
            //获取采集终端设备信息
            GmDevTermGetRequest gmDevTermGetRequest = new GmDevTermGetRequest();
            gmDevTermGetRequest.setAccessGatewayId(devTermId);
            GmDevTermGetResponse gmDevTermGetResponse = new GmDevTermGetResponse();
            try {
                gmDevTermGetResponse = gmDevTermService.getGmDevTerm(gmDevTermGetRequest);
            } catch (Exception e) {
                LOGGER.info(" >>> 重复网关编号：" + devTermId);
            }
            if(gmDevTermGetResponse.isSuccess()) {
                //更新采集终端设备工况信息
                GmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new GmopsDevTermRefreshRequest();
                gmopsDevTermRefreshRequest.setDevTermId(gmDevTermGetResponse.getGmDevTerm().getId());
                gmopsDevTermRefreshRequest.setGmtHeartbeatUp(System.currentTimeMillis());
                gmopsDevTermRefreshRequest.setGmtMessageUp(System.currentTimeMillis());
                gmopsDevTermRefreshRequest.setGmtMeasdataUp(System.currentTimeMillis());
                GmopsDevTermRefreshResponse gmopsDevTermRefreshResponse = gmopsDevTermService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
                if(LOGGER.isDebugEnabled()) {
                    LOGGER.debug("gmopsDevTermRefreshResponse : " + gmopsDevTermRefreshResponse);
                }
            }
        }

        private void updateGmopsDevMeter(Long measPointId, Map<String, Object> measDataInfoSet) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   measPointId        : " + JsonConvertUtils.convertToString(measPointId));
                LOGGER.debug("   measDataInfoSet    : " + JsonConvertUtils.convertToString(measDataInfoSet));
            }
            //
            GmDevMeterGetRequest gmDevMeterGetRequest = new GmDevMeterGetRequest();
            gmDevMeterGetRequest.setMeasPointId(measPointId);
            GmDevMeterGetResponse gmDevMeterGetResponse = gmDevMeterService.getGmDevMeter(gmDevMeterGetRequest);
            GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
            if (gmDevMeterGetResponse.isSuccess()) {
                gmopsDevMeterRefreshRequest = new GmopsDevMeterRefreshRequest();
                gmopsDevMeterRefreshRequest.setDevMeterId(gmDevMeterGetResponse.getGmDevMeter().getId());
                gmopsDevMeterRefreshRequest.setGmtMessageUp(System.currentTimeMillis());
                gmopsDevMeterRefreshRequest.setGmtMeasdataUp(System.currentTimeMillis());
                if (measDataInfoSet != null) {
                    Integer meterStateOpen = (Integer) measDataInfoSet.get("meter_state_open");
                    if (meterStateOpen != null) {
                        gmopsDevMeterRefreshRequest.setMeterStateOpen(meterStateOpen);
                    }
                }
            }
            GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = gmopsDevMeterService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   gmopsDevMeterRefreshResponse   : " + JsonConvertUtils.convertToString(gmopsDevMeterRefreshResponse));
            }
        }
    }
}
