package com.gaea.iesms.bm.mqttHandler.handler;

import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.gaea.iesms.bm.mqttHandler.gateway.MqttGateway;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.bm.mqttHandler.model.entity.MessageAnalysis;
import com.gaea.iesms.bm.mqttHandler.model.entity.MqttmsgReceivedLog;
import com.gaea.iesms.bm.mqttHandler.service.MqttmsgLogService;
import com.gaea.iesms.bm.mqttHandler.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.UUID;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/10 13:56
 */
@Component
public class TopicBasedMessageHandler implements MessageHandler {

    @Value("${spring.mqtt.receiver.client-id}")
    private String receiverClientId;

    @Autowired
    public MqttmsgLogService mqttmsgLogService;

    @Autowired
    private DingiotReceiveMessageHandler dingiotReceiveMessageHandler;

    @Autowired
    private JinHua104ReceiveMessageHandler jinHua104ReceiveMessageHandler;

    @Autowired
    private JalasmartReceiveMessageHandler jalasmartReceiveMessageHandler;

    @Autowired
    private  BigLotusReceiveMessageHandler bigLotusReceiveMessageHandler;

    @Autowired
    private  EMSReceiveMessageHandler emsReceiveMessageHandler;


    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();


    @Override
    public void handleMessage(Message message) {
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");
        int lastIndex = topic.lastIndexOf("/");
        String resultTopic = topic.substring(0, lastIndex);
        if (topic.contains("b03b99VXEV1")) {
            resultTopic = "/b03b99VXEV1";
        }
        //获取报文的消息体
        String payload = (String) message.getPayload();
        //获取id
        UUID uuid = (UUID) message.getHeaders().get("id");
        String receivedMessageId = (uuid != null ? uuid.toString() : "");
        //将订阅主题按"/"进行分割，转成String数组
        String[] tpcs = StringUtils.split(topic, "/");
        //接入网关设备所属产品
        String upcommProductKey = tpcs[0];
        //获取时间戳
        Long now = System.currentTimeMillis();

        MqttmsgReceivedLog receivedLog = new MqttmsgReceivedLog()
                .setId(SNOWFLAKE_GENERATOR.next())
                .setPayload(payload)
                .setTopic(topic)
                .setQos((int) message.getHeaders().get("mqtt_receivedQos"))
                .setRetained((boolean) message.getHeaders().get("mqtt_receivedRetained") ? 1 : 0)
                .setDuplicate((boolean) message.getHeaders().get("mqtt_duplicate") ? 1 : 0)
                .setReceivedProductKey(upcommProductKey)
                .setReceivedClientId(receiverClientId)
                .setReceivedMessageId(receivedMessageId)
                .setGmtCreate(now);

        //报文检查
        Boolean payloadCheckResult = payloadCheck(receivedLog, resultTopic);
        //插入报文日志表
//        mqttmsgLogService.insertOrUpdateMqttmsgReceivedLog(receivedLog);
        if (payloadCheckResult) {
            if (resultTopic.equals(TopicEnum.DINGIIOT.getTopic())){
                dingiotReceiveMessageHandler.handleMessage(message);
            }
            if (resultTopic.equals(TopicEnum.JALASMART.getTopic())){
                jalasmartReceiveMessageHandler.handleMessage(message);
            }
            if (resultTopic.equals(TopicEnum.BIGLOTUS.getTopic())){
                bigLotusReceiveMessageHandler.handleMessage(message);
            }
            if (resultTopic.equals(TopicEnum.JINHUA104.getTopic())){
                jinHua104ReceiveMessageHandler.handleMessage(message);
            }
            if (resultTopic.equals(TopicEnum.EMS.getTopic())){
                emsReceiveMessageHandler.handleMessage(message);
            }
        }
    }

    private Boolean payloadCheck(MqttmsgReceivedLog receivedLog,String resultTopic) {
        String payload = receivedLog.getPayload();

        if (TopicEnum.DINGIIOT.getTopic().equals(resultTopic)){
            // 是否能转成json格式
            JSONObject payloadObj = null;
            try{
                payloadObj = JSONUtil.parseObj(payload);
            }catch(JSONException e){
                receivedLog.setErrorFlag(1);
                receivedLog.setErrorMessage(e.getMessage());
                return false;
            }
            //检查报文是否含有中文
            if (StringUtil.containsChinese(payloadObj.toString())){
                receivedLog.setErrorFlag(1);
                receivedLog.setErrorMessage("报文含中文");
                return false;
            }
        }

        if (TopicEnum.JINHUA104.getTopic().equals(resultTopic)){
            MessageAnalysis messageAnalysis=JSONUtil.parseObj(payload).toBean(MessageAnalysis.class);
            if (StringUtils.isEmpty(messageAnalysis.getMac())||StringUtils.isEmpty(messageAnalysis.getCa())){
                receivedLog.setErrorFlag(1);
                receivedLog.setErrorMessage("终端："+messageAnalysis.getMac()+"    表计："+messageAnalysis.getCa()+"中有空");
                return false;
            }
        }

        if (TopicEnum.JALASMART.getTopic().equals(resultTopic)){
            if (StringUtils.isEmpty(payload)||"{}".equals(payload) ){
                receivedLog.setErrorFlag(1);
                receivedLog.setErrorMessage("数据为空");
                return false;
            }
        }

        return true;
    }

}