package com.gaea.iesms.bm.mqttHandler.model.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 报文解析实体类
 * @author Lin yicheng
 * @date 2022/7/19 17:53
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Builder
public class MessageAnalysis implements Serializable {

    private static final long serialVersionUID = -5744117846613487488L;

    /**
     * 终端标号
     */
    private String mac;

    /**
     * 表计地址
     */
    private String ca;

    /**
     * 量测数据项集合
     */
    private List<MeasuredValue> MeasuredValue;

    /**
     * 遥信数据项集合
     */
    private List<SinglePoint> SinglePoint;

}
