package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：/productKey/device/ parameter_3
 * 数据格式：
 * {
 *     "ControllerID":"589abebc690e76137c0f6472",
 *     "Lines":[
 *         {
 *             "LineNo":128,
 *             "CUR_Mix":63,
 *             "CUR_T":63,
 *             "Over":270,
 *             "Over_T":5,
 *             "Under":170,
 *             "Under_T":5,
 *             "FAC":1000,
 *             "FAC_T":5,
 *             "Tmp_Max":80,
 *             "Tmp_T":5
 *         }
 *     ]
 * }
 *
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayParameter3MqttJsonDto implements Serializable {

    private static final long serialVersionUID = -6533573274335969182L;

    @JsonProperty("CONTROLLERID")
    private String controllerId;

    @JsonProperty("LINES")
    private List<GatewayParameter3LineMqttJsonDto> lines;

}
