package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/status
 * 数据格式：
 * {
 *     "TimeStamp": 1491356290,
 *     "Lines": [
 *         {
 *             "LineNo": 1,
 *             "Status": 0
 *         },
 *         {
 *             "LineNo": 2,
 *             "Status": 1
 *         }
 *     ]
 * }
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合。LineNo表示线路编号，Status表示线路状态，1表示开，0表示关。
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayStatusMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 4941952819381834233L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayStatusLineMqttJsonDto> lines;

}
