package com.gaea.iesms.bm.mqttHandler.model.response;

import com.gaea.iesms.bm.mqttHandler.constant.MqttResponseResultEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MqttReturnResponse implements Serializable {

    private static final long serialVersionUID = 821279589359372214L;

    /**
     * 返回状态码：SUCCESS - 成功；FAILURE - 失败；
     */
    private String returnCode;

    /**
     * 返回信息：当返回状态码为FAILURE时返回信息为错误原因
     */
    private String returnMsg;

    public void setReturnResponseResult(MqttResponseResultEnum responseResult) {
        this.returnCode = responseResult.getReturnCode();
        this.returnMsg = responseResult.getReturnMsg();
    }

    public boolean isSuccess() {
        return "SUCCESS".equals(this.returnCode);
    }

}