package com.gaea.iesms.bm.mqttHandler.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.iesms.bm.mqttHandler.constant.MqttResponseResultEnum;
import com.gaea.iesms.bm.mqttHandler.mapper.MqttmsgLogMapper;
import com.gaea.iesms.bm.mqttHandler.model.entity.MqttmsgReceivedLog;
import com.gaea.iesms.bm.mqttHandler.model.response.MqttReturnResponse;
import com.gaea.iesms.bm.mqttHandler.service.MqttmsgLogService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author Lin yicheng
 * @date 2022/3/22 14:39
 */
@Service
public class MqttmsgLogServiceImpl implements MqttmsgLogService {

    @Resource
    private MqttmsgLogMapper mqttmsgLogMapper;


    @Override
    public MqttReturnResponse insertOrUpdateMqttmsgReceivedLog(MqttmsgReceivedLog receivedLog) {
        MqttReturnResponse dingiReturnResponse = new MqttReturnResponse();
        dingiReturnResponse.setReturnResponseResult(MqttResponseResultEnum.FAILURE);
        int result = mqttmsgLogMapper.insertMqttLog(receivedLog);
        if (result >0) {
            dingiReturnResponse.setReturnResponseResult(MqttResponseResultEnum.SUCCESS);
        }
        return dingiReturnResponse;
    }

    @Override
    public void delete() {
//        long millisecond = NumberUtil.parseLong(String.valueOf(NumberUtil.sub(NumberUtil.toBigDecimal(System.currentTimeMillis()),NumberUtil.mul(15,24,60,60,1000))));
        long millisecond = System.currentTimeMillis() - (3 * 24 * 60 * 60 * 1000);
        LambdaQueryWrapper<MqttmsgReceivedLog> query = Wrappers.<MqttmsgReceivedLog>lambdaQuery()
                .le(MqttmsgReceivedLog::getGmtCreate,millisecond);
        mqttmsgLogMapper.delete(query);
    }

    @Override
    public Long getDevMeterId(String devTermCommAddr, String devMeterCommAddr) {
        return mqttmsgLogMapper.getDevMeterId(devTermCommAddr, devMeterCommAddr);
    }

}
