package com.gaea.iesms.bm.mqttHandler.util;

import com.easesource.data.id.algorithm.EaseSnowflake;
import com.easesource.data.id.generator.IdGenerator;
import com.easesource.data.id.register.IdGeneratorConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.io.IOException;

/**
 *
 * @author Nick Zhang
 * @date 2019-05-20
 */
public class EaseSystemIdGenerator implements IdGenerator, IdGeneratorConnector {


    private final Logger logger = LoggerFactory.getLogger(getClass());

    private EaseSnowflake easeSnowflake;

    private volatile boolean initialized = false;
    private volatile boolean working = false;
    private volatile boolean connecting = false;

    @Override
    public long nextId() {
        if(isWorking()) {
            return easeSnowflake.nextId();
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    public long[] nextIds(int size) {
        if(isWorking()) {
            return easeSnowflake.nextIds(size);
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    public String nextStringId() {
        if(isWorking()) {
            return easeSnowflake.nextStringId();
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    public String[] nextStringIds(int size) {
        if(isWorking()) {
            return easeSnowflake.nextStringIds(size);
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    @PostConstruct
    public synchronized void init() {
        if(!initialized) {
            connect();
            initialized = true;
        }
    }

    @Override
    public void connect() {
        if(!isConnecting()) {
            working = false;
            connecting = true;
            long flag = 1L;
            long sortid = 0L;
            long regsn = 0L;
            easeSnowflake = new EaseSnowflake(flag, sortid, regsn);
            working = true;
            connecting = false;
        }
        else {
            logger.info("worker is connecting, skip this time of register.");
        }
    }

    @Override
    public void reconnect() {

    }

    @Override
    public void suspend() {
        this.working = false;
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public boolean isConnecting() {
        return this.connecting;
    }

    @Override
    @PreDestroy
    @SuppressWarnings("all")
    public synchronized void close() throws IOException {
        reset();
    }

    protected void reset() {
        initialized = false;
        working = false;
        connecting = false;
    }

}
