package com.gaea.iesms.bm.mqttHandler.util;

import com.gaea.iesms.core.feign.enums.TopicEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/12 16:12
 */
@Component
public class MeasitemcodeProp {

    private static final Logger LOGGER = LoggerFactory.getLogger(MeasitemcodeProp.class);

    public String getMeasitemCodeFromProperties(String modelAttribute,String topic) throws IOException {
        String propName= TopicEnum.findPropName(topic);
        InputStream in = this.getClass().getResourceAsStream(propName);
        Properties props = new Properties();
        InputStreamReader inputStreamReader = new InputStreamReader(in, StandardCharsets.UTF_8);
        props.load(inputStreamReader);
        return props.getProperty(modelAttribute);
    }


}
