package com.gaea.iesms.bm.mqttHandler.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.model.entity.*;
import com.gaea.iesms.bm.mqttHandler.util.MeasitemcodeProp;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.core.feign.request.alarm.PushAlarmRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayGetRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoBatchUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevTermGetRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevMeterRefreshRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevTermRefreshRequest;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayGetResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointListResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointVo;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevMeterGetResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevTermGetResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevMeterRefreshResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevTermRefreshResponse;
import com.gaea.iesms.core.feign.service.*;

import com.gaea.utils.ObjectUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevMeterGetRequest;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author Lin yicheng
 * @date 2022/7/19 14:27
 *  数据处理服务
 */
@Component
public class EMSReceiveMessageHandler implements MessageHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(EMSReceiveMessageHandler.class);

    private static final String UPCOMM_PROTO = "EMS";

    private static final String UPCOMM_PRODUCT_KEY = "EMS";

    @Autowired
    private MeasitemcodeProp measitemcodeProp;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private JrEmsCommonService jrEmsCommonService;

    @Resource
    private RemoteIotService remoteIotService;

    @Resource
    private RemoteAlarmService remoteAlarmService;

    @Resource
    private RemoteEmsService remoteEmsService;


    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(256, 256, 120, TimeUnit.SECONDS, new LinkedBlockingDeque<>(200), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());


    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        try {
            if (ObjectUtil.isNotEmpty(message.getPayload())) {
                POOL.execute(new Thread(() -> {
                    handle(message);
                }));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * handle 处理类
     * @param
     */
    public void handle(Message<?> message) {
        String payload= (String) message.getPayload();
        //报文解析成实体类
        EMSReceiveMessageDo emsReceiveMessageDo = JSONUtil.parseObj(payload).toBean(EMSReceiveMessageDo.class);
        //终端编号
        String sn = emsReceiveMessageDo.getSn().toUpperCase();
        LOGGER.info("接收到数据：{}",sn);
        for (EMSData emsdata:emsReceiveMessageDo.getData()) {
            //表计地址
            String ca = emsdata.getDevNumber().toUpperCase();
            List<EMSDevData>  emsDevDataList=emsdata.getDevData();

            //存放数据Map
            Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap = Maps.newHashMap();
            Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();
            Long now = System.currentTimeMillis();
            Map<String, Double> eppSwMap = Maps.newConcurrentMap();

            //获取运行网关设备
            RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
            runAccessGatewayGetRequest.setProductKey(UPCOMM_PRODUCT_KEY);
            runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
            runAccessGatewayGetRequest.setUpcommLogicAddr(sn);
            R<RunAccessGatewayGetResponse> gatewayResult=dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
            RunAccessGatewayGetResponse runAccessGatewayGetResponse = gatewayResult.getData();
            if (ObjectUtils.isNotEmpty(runAccessGatewayGetResponse) && ObjectUtils.isNotEmpty(runAccessGatewayGetResponse.getRunAccessGateway()) &&
                    CollectionUtil.isNotEmpty(runAccessGatewayGetResponse.getRunMeasPointList())) {
                //数据中心更新运行接入网关设备工况信息
                RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
                runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
                runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(now);
                runAccessGatewayOpsInfoUpdateRequest.setGmtMessageUp(now);
                runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(now);
                R runAccessGatewayOpsInfoUpdateResponse = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
                //获取采集终端设备信息
                RemoteGmDevTermGetRequest remoteGmDevTermGetRequest=new RemoteGmDevTermGetRequest();
                remoteGmDevTermGetRequest.setAccessGatewayId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
                R<RemoteGmDevTermGetResponse> gmDevTerm = remoteIotService.getGmDevTerm(remoteGmDevTermGetRequest);
                if (gmDevTerm.isSuccess()) {
                    //更新采集终端设备工况信息
                    RemoteGmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new RemoteGmopsDevTermRefreshRequest();
                    gmopsDevTermRefreshRequest.setDevTermId(gmDevTerm.getData().getGmDevTerm().getId());
                    gmopsDevTermRefreshRequest.setGmtHeartbeatUp(now);
                    gmopsDevTermRefreshRequest.setGmtMessageUp(now);
                    gmopsDevTermRefreshRequest.setGmtMeasdataUp(now);
                    R<RemoteGmopsDevTermRefreshResponse> remoteGmopsDevTermRefreshResponseR = remoteIotService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
                }
                for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
//                    LOGGER.info("量测点标识:{}", runMeasPointVo.getMeasCommAddr() + "---" + runMeasPointVo.getId());
                    String measCommAddr = StrUtil.trim(runMeasPointVo.getMeasCommAddr()).toUpperCase();
                    //key为接入网关设备所属产品#上行通讯规约#终端地址#量测通信地址，value为量测点标识，保存key与value的缓存存入gaeadcu11MeasPointIdReverseCache
                    measPointIdReverseMap.put(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, measCommAddr), runMeasPointVo.getId());
                }
            }

            //获取量测点标识
            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, ca));
            Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
            if (measPointId != null) {
                RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
                runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
                runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(now);
                runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(now);
                R runMeasPointOpsInfoUpdateResponse = dataCenterCommonService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
                //对量测项数据进行处理
                if (CollectionUtil.isNotEmpty(emsDevDataList)) {
                    for (EMSDevData emsDevData : emsDevDataList) {
                        String dataItem = emsDevData.getDataItem();
                        BigDecimal value = emsDevData.getValue();
                        if (dataItem != null && dataItem!= "") {
                            Map<String, Object> measDataInfo = Maps.newHashMap();
                            //获取量测项编码
                            String measitemCode = null;
                            try {
                                measitemCode = measitemcodeProp.getMeasitemCodeFromProperties(dataItem,(String) message.getHeaders().get("mqtt_receivedTopic"));
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
//                            LOGGER.info("ca:"+ca+"dataItem:"+dataItem+"measitemcode:"+measitemCode);
                            if (StrUtil.isEmpty(measitemCode)) {
                                continue;
                            }
                            if ("gen_push_alarm".equals(measitemCode)){
                                //推送告警 1告警 0复归
                                if (emsDevData.getValue().compareTo(BigDecimal.ONE) == 0){
                                    PushAlarmRequest pushAlarmRequest = new PushAlarmRequest();
                                    pushAlarmRequest.setSoeObjectId(measPointId);
                                    LOGGER.info("推送告警>>>>"+ JSONObject.toJSONString(pushAlarmRequest));
                                    remoteEmsService.pushAlertAndGenerateSolution(pushAlarmRequest);
                                }
                                if (emsDevData.getValue().compareTo(BigDecimal.ZERO) == 0){
                                    PushAlarmRequest pushAlarmRequest = new PushAlarmRequest();
                                    pushAlarmRequest.setSoeObjectId(measPointId);
                                    LOGGER.info("推送复归>>>>"+ JSONObject.toJSONString(pushAlarmRequest));
                                    remoteEmsService.resetAlertAndCompletePlan(pushAlarmRequest);
                                }
                            }
                            if ("gen_watt_acpt".equals(measitemCode)){

                            }

                            BigDecimal measDataValue = value != null ? value : BigDecimal.ZERO;
                            if ("gen_watt_paet1".equals(measitemCode)||"gen_watt_paet2".equals(measitemCode)||"gen_watt_raet1".equals(measitemCode)||"gen_watt_raet2".equals(measitemCode)){
                                eppSwMap.put(measitemCode,Double.parseDouble(measDataValue.toString()));
                            }
                            if ((ca.contains("GF")||ca.contains("CDZ"))&&measitemCode.equals("gen_watt_acpt")){
                                measDataValue=measDataValue.abs();
                            }
                            if (ca.contains("ACDC")&&(measitemCode.equals("gen_watt_acpt")||measitemCode.equals("gen_watt_ia")||measitemCode.equals("gen_watt_ib")||measitemCode.equals("gen_watt_ic"))){
                                measDataValue=measDataValue.negate();
                            }
                            if (ca.contains("BMS")&&measitemCode.equals("gen_watt_acpt")){
                                measDataValue=measDataValue.negate();
                            }

                            measDataInfo.put("pointId", measPointId);
                            measDataInfo.put("measItemCode", measitemCode);
                            measDataInfo.put("measDataClass", "java.math.BigDecimal");
                            measDataInfo.put("measDataValue", measDataValue);
                            measDataInfo.put("measDataSource", 0);
                            insideMap.put(measitemCode, measDataInfo);
                        }
                    }
                    if (MapUtil.isNotEmpty(insideMap)) {
                        if (eppSwMap.get("gen_watt_paet1")!=null&&eppSwMap.get("gen_watt_paet2")!=null){
                            Map<String, Object> measDataInfo = Maps.newHashMap();
                            measDataInfo.put("pointId", measPointId);
                            measDataInfo.put("measItemCode", "gen_watt_paet");
                            measDataInfo.put("measDataClass", "java.math.BigDecimal");
                            measDataInfo.put("measDataValue", eppSwMap.get("gen_watt_paet1")*65536+eppSwMap.get("gen_watt_paet2"));
                            measDataInfo.put("measDataSource", 0);
                            insideMap.put("gen_watt_paet", measDataInfo);
                        }
                        if (eppSwMap.get("gen_watt_raet1")!=null&&eppSwMap.get("gen_watt_raet2")!=null){
                            Map<String, Object> measDataInfo = Maps.newHashMap();
                            measDataInfo.put("pointId", measPointId);
                            measDataInfo.put("measItemCode", "gen_watt_raet");
                            measDataInfo.put("measDataClass", "java.math.BigDecimal");
                            measDataInfo.put("measDataValue", eppSwMap.get("gen_watt_raet1")*65536+eppSwMap.get("gen_watt_raet2"));
                            measDataInfo.put("measDataSource", 0);
                            insideMap.put("gen_watt_raet", measDataInfo);
                        }
                        batchMeasDataInfosMap.put(measPointId.toString(), insideMap);
                    }
                }
            }

            //处理表计不存在的数据
            if (StringUtils.isNotEmpty(ca)){
                //获取原存在表计
                R<RunMeasPointListResponse> runMeasPointListBySn = dataCenterCommonService.getRunMeasPointListBySn(sn);
                RunMeasPointListResponse runMeasPointListResponse= runMeasPointListBySn.getData();
                List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
                List<String> measCommAddrList=runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
                //若不存在上报表计 则插入相应实体模型
                if (!measCommAddrList.contains(ca)) {
                    R flag = dataCenterCommonService.brushMeter(sn, ca, TopicEnum.JINHUA104.getTopic());
                    LOGGER.info("===================终端" + sn + "表计地址" + ca+"插入成功！！！");
                }
            }

            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
                //数据中心批量更新数据
                dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
                //数据中心批量更新量测点工况信息
                RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest = new RunMeasPointOpsInfoBatchUpdateRequest();
                runMeasPointOpsInfoBatchUpdateRequest.setMeasPointIdList(batchMeasDataInfosMap.keySet().stream().map(Long::valueOf).collect(Collectors.toList()));
                runMeasPointOpsInfoBatchUpdateRequest.setGmtMessageUp(now);
                runMeasPointOpsInfoBatchUpdateRequest.setGmtMeasdataUp(now);
                R runMeasPointOpsInfoBatchUpdateResponse = dataCenterCommonService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
            }

//            LOGGER.info("数据处理完成>>>:{}",JSONObject.toJSONString(batchMeasDataInfosMap));
            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
//                //告警推送
//                R deviceBymeterAndTerm = jrEmsCommonService.getDeviceBymeterAndTerm(sn, ca);
//                if (deviceBymeterAndTerm.getCode()==200) {
//                    Long deviceId  = (Long) deviceBymeterAndTerm.getData();
//                    if (deviceId!=null) {
//                        R deviceSetting = remoteAlarmService.findDeviceSetting(deviceId.toString());
//                        if (deviceSetting.getData()!=null){
//                            remoteAlarmService.dataCenterBoundSoeRecord();
//                        }
//                    }
//                }

                //更新量测表计设备工况
                for (String pointIdString : batchMeasDataInfosMap.keySet()) {
                    Long pointId=Long.valueOf(pointIdString);
                    Map<String, Map<String, Object>> insideMap1 = batchMeasDataInfosMap.get(pointId.toString());
                    RemoteGmDevMeterGetRequest gmDevMeterGetRequest = new RemoteGmDevMeterGetRequest();
                    gmDevMeterGetRequest.setMeasPointId(pointId);
                    R<RemoteGmDevMeterGetResponse> r = remoteIotService.getGmDevMeter(gmDevMeterGetRequest);
                    RemoteGmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
                    if (r.getCode()==200&&r.getData().getGmDevMeter()!=null) {
                        RemoteGmDevMeterGetResponse remoteGmDevMeterGetResponse=r.getData();
                        gmopsDevMeterRefreshRequest = new RemoteGmopsDevMeterRefreshRequest();
                        gmopsDevMeterRefreshRequest.setDevMeterId(remoteGmDevMeterGetResponse.getGmDevMeter().getId());
                        gmopsDevMeterRefreshRequest.setGmtMessageUp(now);
                        gmopsDevMeterRefreshRequest.setGmtMeasdataUp(now);
                        Map<String, Object> measDataInfoSetMap = Maps.newHashMap();
                        for (String measItemCode : insideMap1.keySet()) {
                            Map<String, Object> measDataInfo1 = insideMap1.get(measItemCode);
                            gmopsDevMeterRefreshRequest.setGmtReadingUp(now);
                            measDataInfoSetMap.put(measItemCode, measDataInfo1.get("measDataValue"));
                        }
                        gmopsDevMeterRefreshRequest.setMeasDataInfoSet(JsonConvertUtils.convertToString(measDataInfoSetMap));
                    }
                    if (ObjectUtil.isNotEmpty(gmopsDevMeterRefreshRequest)) {
                        if (ca.equals("6")){
                            gmopsDevMeterRefreshRequest.setMeasDataInfoSet(null);
                        }
                        R<RemoteGmopsDevMeterRefreshResponse> remoteGmopsDevMeterRefreshResponseR = remoteIotService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
                    }
                }
            }

        }

    }

}
