package com.gaea.iesms.bm.mqttHandler.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.mqttHandler.model.entity.*;
import com.gaea.iesms.bm.mqttHandler.util.MeasitemcodeProp;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.core.feign.request.alarm.PushAlarmRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayGetRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoBatchUpdateRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunMeasPointOpsInfoUpdateRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevMeterGetRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevTermGetRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevMeterRefreshRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmopsDevTermRefreshRequest;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayGetResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointListResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointVo;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevMeterGetResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevTermGetResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevMeterRefreshResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmopsDevTermRefreshResponse;
import com.gaea.iesms.core.feign.service.*;
import com.gaea.utils.ObjectUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author Lin yicheng
 * @date 2022/7/19 14:27
 *  数据处理服务
 */
@Component
public class JrEMSReceiveMessageHandler implements MessageHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(JrEMSReceiveMessageHandler.class);

    private static final String UPCOMM_PROTO = "JREMS";

    private static final String UPCOMM_PRODUCT_KEY = "JREMS";

    @Autowired
    private MeasitemcodeProp measitemcodeProp;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private JrEmsCommonService jrEmsCommonService;

    @Resource
    private RemoteIotService remoteIotService;

    @Resource
    private RemoteAlarmService remoteAlarmService;

    @Resource
    private RemoteEmsService remoteEmsService;

    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(256, 256, 120, TimeUnit.SECONDS, new LinkedBlockingDeque<>(200), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());


    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        try {
            if (ObjectUtil.isNotEmpty(message.getPayload())) {
                POOL.execute(new Thread(() -> {
                    handle(message);
                }));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * handle 处理类
     * @param
     */
    public void handle(Message<?> message) {
        String payload= (String) message.getPayload();
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");
        //报文解析成实体类
        JrEMSReceiveMessageDo emsReceiveMessageDo = JSONUtil.parseObj(payload).toBean(JrEMSReceiveMessageDo.class);

        String type = emsReceiveMessageDo.getSignature().getType();
        switch (type) {
            case "PCS":
                PCSDeviceData pcsDeviceData = JSONUtil.parseObj(payload).toBean(PCSDeviceData.class);
                emsReceiveMessageDo.setSn("MWJRPCS001");
                pcsDataProcessing(pcsDeviceData,emsReceiveMessageDo);
                break;
            //bms
            case "BAT_STACK":
                BMSDeviceData bmsDeviceData = JSONUtil.parseObj(payload).toBean(BMSDeviceData.class);
                if (topic.contains("PCC1")){
                    emsReceiveMessageDo.setSn("MWJRBMS001");
                }else{
                    emsReceiveMessageDo.setSn("MWJRBMS002");
                }
                bmsDataProcessing(bmsDeviceData,emsReceiveMessageDo);
                break;
//            case "EM2":
//                MultifunctionalMeterData multifunctionalMeterData = JSONUtil.parseObj(payload).toBean(MultifunctionalMeterData.class);
//                emsReceiveMessageDo.setSn("MWJREM2001");
//                multifunctionalMeteDataProcessing(multifunctionalMeterData,emsReceiveMessageDo);
//                break;
//            case "AC":
//                AirConditionerData airConditionerData = JSONUtil.parseObj(payload).toBean(AirConditionerData.class);
//                emsReceiveMessageDo.setSn("MWJRAC001");
//                emsReceiveMessageDo.setAirConditionerData(airConditionerData);
//                break;
            default:
                break;
        }
        if (ObjectUtil.isEmpty(emsReceiveMessageDo.getSn())){
            return;
        }
        dataProcessing(message, emsReceiveMessageDo);
    }

    private void multifunctionalMeteDataProcessing(MultifunctionalMeterData multifunctionalMeterData, JrEMSReceiveMessageDo emsReceiveMessageDo) {
        try{
            List<EMSData> data =new ArrayList<>();
            EMSData emsData=new EMSData();
            emsData.setDevNumber("MWEM2"+multifunctionalMeterData.getSignature().getName());
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>"+emsData.getDevNumber());
            emsData.setDevName("EM2");
            List<EMSDevData> devData=new ArrayList<>();
            if (multifunctionalMeterData.getRuntime().getCurrent()!=null){
                EMSDevData devDataIPhaseA = new EMSDevData();
                devDataIPhaseA.setDataItem("IA");
                devDataIPhaseA.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getCurrent().getPhaseA()));
                devData.add(devDataIPhaseA);
                EMSDevData devDataIPhaseB = new EMSDevData();
                devDataIPhaseB.setDataItem("IB");
                devDataIPhaseB.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getCurrent().getPhaseB()));
                devData.add(devDataIPhaseB);
                EMSDevData devDataIPhaseC = new EMSDevData();
                devDataIPhaseC.setDataItem("IC");
                devDataIPhaseC.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getCurrent().getPhaseC()));
                devData.add(devDataIPhaseC);
            }
            if (multifunctionalMeterData.getRuntime().getVoltage()!=null){
                EMSDevData devDataVPhaseA = new EMSDevData();
                devDataVPhaseA.setDataItem("UA");
                devDataVPhaseA.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getVoltage().getPhaseA()));
                devData.add(devDataVPhaseA);
                EMSDevData devDataVPhaseB = new EMSDevData();
                devDataVPhaseB.setDataItem("UB");
                devDataVPhaseB.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getVoltage().getPhaseB()));
                devData.add(devDataVPhaseB);
                EMSDevData devDataVPhaseC = new EMSDevData();
                devDataVPhaseC.setDataItem("UC");
                devDataVPhaseC.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getVoltage().getPhaseC()));
                devData.add(devDataVPhaseC);
            }
            if (multifunctionalMeterData.getRuntime().getPower()!=null){
                EMSDevData devDataP = new EMSDevData();
                devDataP.setDataItem("P");
                devDataP.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getPower().getActive().getTotal()/1000));
                devData.add(devDataP);

            }
            if (multifunctionalMeterData.getRuntime().getPower().getReactive()!=null){
                EMSDevData devDataQ = new EMSDevData();
                devDataQ.setDataItem("Q");
                devDataQ.setValue(BigDecimal.valueOf(multifunctionalMeterData.getRuntime().getPower().getReactive().getTotal()/1000));
                devData.add(devDataQ);
            }
            emsData.setDevData(devData);
            data.add(emsData);
            emsReceiveMessageDo.setData(data);
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    private void bmsDataProcessing(BMSDeviceData bmsDeviceData, JrEMSReceiveMessageDo emsReceiveMessageDo) {
        List<EMSData> data =new ArrayList<>();
        EMSData emsData=new EMSData();
        emsData.setDevNumber(bmsDeviceData.getSignature().getName());
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>"+emsData.getDevNumber());
        emsData.setDevName("BMS");
        List<EMSDevData> devData=new ArrayList<>();
        BMSDeviceData.Runtime runtime = bmsDeviceData.getRuntime();
        if (runtime.getPower()!=null){
            EMSDevData emsDevDatapower = new EMSDevData();
            emsDevDatapower.setDataItem("P");
            emsDevDatapower.setValue(BigDecimal.valueOf(runtime.getPower().getAvg()));
            devData.add(emsDevDatapower);
            emsData.setDevData(devData);
            data.add(emsData);
            emsReceiveMessageDo.setData(data);
            R r = jrEmsCommonService.targetControl(emsDevDatapower.getValue().doubleValue(), "1907700006248431618");
            return;
        }
        EMSDevData devDataIPhaseA = new EMSDevData();
        devDataIPhaseA.setDataItem("IA");
        devDataIPhaseA.setValue(BigDecimal.valueOf(runtime.getCurrent().getAvg()));
        devData.add(devDataIPhaseA);
        EMSDevData emsDevDataVPhaseA = new EMSDevData();
        emsDevDataVPhaseA.setDataItem("UA");
        emsDevDataVPhaseA.setValue(BigDecimal.valueOf(runtime.getVoltage().getAvg()));
        devData.add(emsDevDataVPhaseA);
        EMSDevData emsDevDataTemp = new EMSDevData();
        emsDevDataTemp.setDataItem("temp");
        emsDevDataTemp.setValue(BigDecimal.valueOf(runtime.getTemperature().getAvg()));
        devData.add(emsDevDataTemp);
        EMSDevData emsDevDataSOC = new EMSDevData();
        emsDevDataSOC.setDataItem("SOC");
        emsDevDataSOC.setValue(BigDecimal.valueOf(runtime.getSoc().getAvg()));
        devData.add(emsDevDataSOC);
        EMSDevData emsDevDataSOH = new EMSDevData();
        emsDevDataSOH.setDataItem("SOH");
        emsDevDataSOH.setValue(BigDecimal.valueOf(runtime.getSoh().getAvg()));
        devData.add(emsDevDataSOH);

        emsData.setDevData(devData);
        data.add(emsData);
        emsReceiveMessageDo.setData(data);

    }

    private void pcsDataProcessing(PCSDeviceData pcsDeviceData, JrEMSReceiveMessageDo emsReceiveMessageDo) {
        List<EMSData> data =new ArrayList<>();
        EMSData emsData=new EMSData();
        emsData.setDevNumber(pcsDeviceData.getSignature().getName());
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>"+emsData.getDevNumber());
        emsData.setDevName("PCS");
        List<EMSDevData> devData=new ArrayList<>();
        PCSDeviceData.ACRuntime acRuntime = pcsDeviceData.getAc_runtime();
        EMSDevData devDataIPhaseA = new EMSDevData();
        devDataIPhaseA.setDataItem("IA");
        devDataIPhaseA.setValue(BigDecimal.valueOf(acRuntime.getCurrent().getPhaseA()));
        devData.add(devDataIPhaseA);
        EMSDevData devDataIPhaseB = new EMSDevData();
        devDataIPhaseB.setDataItem("IB");
        devDataIPhaseB.setValue(BigDecimal.valueOf(acRuntime.getCurrent().getPhaseB()));
        devData.add(devDataIPhaseB);
        EMSDevData devDataIPhaseC = new EMSDevData();
        devDataIPhaseC.setDataItem("IC");
        devDataIPhaseC.setValue(BigDecimal.valueOf(acRuntime.getCurrent().getPhaseC()));
        devData.add(devDataIPhaseC);
        EMSDevData devDataVPhaseA = new EMSDevData();
        devDataVPhaseA.setDataItem("UA");
        devDataVPhaseA.setValue(BigDecimal.valueOf(acRuntime.getVoltage().getPhaseA()));
        devData.add(devDataVPhaseA);
        EMSDevData devDataVPhaseB = new EMSDevData();
        devDataVPhaseB.setDataItem("UB");
        devDataVPhaseB.setValue(BigDecimal.valueOf(acRuntime.getVoltage().getPhaseB()));
        devData.add(devDataVPhaseB);
        EMSDevData devDataVPhaseC = new EMSDevData();
        devDataVPhaseC.setDataItem("UC");
        devDataVPhaseC.setValue(BigDecimal.valueOf(acRuntime.getVoltage().getPhaseC()));
        devData.add(devDataVPhaseC);
        EMSDevData devDataPower = new EMSDevData();
        devDataPower.setDataItem("P");
        devDataPower.setValue(BigDecimal.valueOf(acRuntime.getPower().getActive().getTotal()/1000));
        devData.add(devDataPower);
        EMSDevData devDataPowerReactive = new EMSDevData();
        devDataPowerReactive.setDataItem("Q");
        devDataPowerReactive.setValue(BigDecimal.valueOf(acRuntime.getPower().getReactive().getTotal()/1000));
        devData.add(devDataPowerReactive);
        EMSDevData devDataPowerChage = new EMSDevData();
        devDataPowerReactive.setDataItem("EPP");
        devDataPowerReactive.setValue(BigDecimal.valueOf(pcsDeviceData.getAc_charge().getTotal()/1000));
        devData.add(devDataPowerChage);
        EMSDevData devDataPowerDisChage = new EMSDevData();
        devDataPowerDisChage.setDataItem("EPPSW");
        devDataPowerDisChage.setValue(BigDecimal.valueOf(pcsDeviceData.getAc_discharge().getTotal()/1000));
        devData.add(devDataPowerDisChage);
        EMSDevData devDataChargeStatus = new EMSDevData();
        devDataChargeStatus.setDataItem("20340120802");
        devDataChargeStatus.setValue(BigDecimal.valueOf(pcsDeviceData.getCharge_status()));
        devData.add(devDataChargeStatus);
        chargeStatusProcessing(devDataChargeStatus);
        emsData.setDevData(devData);
        data.add(emsData);
        emsReceiveMessageDo.setData(data);
    }

    private void chargeStatusProcessing(EMSDevData devDataChargeStatus) {
        // 充放电状态 -1:充电, 0:静置, 1:放电
        String status = String.valueOf(devDataChargeStatus.getValue().intValue());
        int resultStatus=2;
        switch (status) {
            case "0":
                resultStatus=2;
                break;
            case "-1":
                resultStatus=3;
                break;
            case "1":
                resultStatus=1;
                break;
            default:
                break;
        }
        jrEmsCommonService.targetControlCallBack(resultStatus);

    }

    private void dataProcessing(Message<?> message, JrEMSReceiveMessageDo emsReceiveMessageDo) {
        //终端编号
        String sn = emsReceiveMessageDo.getSn().toUpperCase();
        LOGGER.info("接收到数据：{}",sn);
        for (EMSData emsdata: emsReceiveMessageDo.getData()) {
            //表计地址
            String ca = emsdata.getDevNumber().toUpperCase();
            List<EMSDevData>  emsDevDataList=emsdata.getDevData();
            //存放数据Map
            Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap = Maps.newHashMap();
            Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();
            Long now = System.currentTimeMillis();
            //获取运行网关设备
            RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
            runAccessGatewayGetRequest.setProductKey(UPCOMM_PRODUCT_KEY);
            runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
            runAccessGatewayGetRequest.setUpcommLogicAddr(sn);
            R<RunAccessGatewayGetResponse> gatewayResult=dataCenterCommonService.getRunAccessGateway(runAccessGatewayGetRequest);
            RunAccessGatewayGetResponse runAccessGatewayGetResponse = gatewayResult.getData();
            if (ObjectUtils.isNotEmpty(runAccessGatewayGetResponse) && ObjectUtils.isNotEmpty(runAccessGatewayGetResponse.getRunAccessGateway()) &&
                    CollectionUtil.isNotEmpty(runAccessGatewayGetResponse.getRunMeasPointList())) {
                //数据中心更新运行接入网关设备工况信息
                RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest = new RunAccessGatewayOpsInfoUpdateRequest();
                runAccessGatewayOpsInfoUpdateRequest.setDevAccessId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
                runAccessGatewayOpsInfoUpdateRequest.setGmtHeartbeatUp(now);
                runAccessGatewayOpsInfoUpdateRequest.setGmtMessageUp(now);
                runAccessGatewayOpsInfoUpdateRequest.setGmtMeasdataUp(now);
                R runAccessGatewayOpsInfoUpdateResponse = dataCenterCommonService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
                //获取采集终端设备信息
                RemoteGmDevTermGetRequest remoteGmDevTermGetRequest=new RemoteGmDevTermGetRequest();
                remoteGmDevTermGetRequest.setAccessGatewayId(runAccessGatewayGetResponse.getRunAccessGateway().getId());
                R<RemoteGmDevTermGetResponse> gmDevTerm = remoteIotService.getGmDevTerm(remoteGmDevTermGetRequest);
                if (gmDevTerm.isSuccess()) {
                    //更新采集终端设备工况信息
                    RemoteGmopsDevTermRefreshRequest gmopsDevTermRefreshRequest = new RemoteGmopsDevTermRefreshRequest();
                    gmopsDevTermRefreshRequest.setDevTermId(gmDevTerm.getData().getGmDevTerm().getId());
                    gmopsDevTermRefreshRequest.setGmtHeartbeatUp(now);
                    gmopsDevTermRefreshRequest.setGmtMessageUp(now);
                    gmopsDevTermRefreshRequest.setGmtMeasdataUp(now);
                    R<RemoteGmopsDevTermRefreshResponse> remoteGmopsDevTermRefreshResponseR = remoteIotService.refreshGmopsDevTerm(gmopsDevTermRefreshRequest);
                }
                for (RunMeasPointVo runMeasPointVo : runAccessGatewayGetResponse.getRunMeasPointList()) {
//                    LOGGER.info("量测点标识:{}", runMeasPointVo.getMeasCommAddr() + "---" + runMeasPointVo.getId());
                    String measCommAddr = StrUtil.trim(runMeasPointVo.getMeasCommAddr());
                    //key为接入网关设备所属产品#上行通讯规约#终端地址#量测通信地址，value为量测点标识，保存key与value的缓存存入gaeadcu11MeasPointIdReverseCache
                    measPointIdReverseMap.put(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, measCommAddr), runMeasPointVo.getId());
                }
            }

            //获取量测点标识
            Long measPointId = measPointIdReverseMap.get(Joiner.on("#").join(UPCOMM_PRODUCT_KEY, UPCOMM_PROTO, sn, ca));
            Map<String, Map<String, Object>> insideMap = Maps.newHashMap();
            if (measPointId != null) {
                RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
                runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
                runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(now);
                runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(now);
                R runMeasPointOpsInfoUpdateResponse = dataCenterCommonService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
                //对量测项数据进行处理
                if (CollectionUtil.isNotEmpty(emsDevDataList)) {
                    for (EMSDevData emsDevData : emsDevDataList) {
                        String dataItem = emsDevData.getDataItem();
                        BigDecimal value = emsDevData.getValue();
                        if (dataItem != null && dataItem!= "") {
                            Map<String, Object> measDataInfo = Maps.newHashMap();
                            //获取量测项编码
                            String measitemCode = null;
                            try {
                                measitemCode = measitemcodeProp.getMeasitemCodeFromProperties(dataItem,(String) message.getHeaders().get("mqtt_receivedTopic"));
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                            LOGGER.info("ca:"+ca+"measitemcode:"+measitemCode);
                            if (StrUtil.isEmpty(measitemCode)) {
                                continue;
                            }
                            BigDecimal measDataValue = value != null ? value : BigDecimal.ZERO;
                            measDataInfo.put("pointId", measPointId);
                            measDataInfo.put("measItemCode", measitemCode);
                            measDataInfo.put("measDataClass", "java.math.BigDecimal");
                            measDataInfo.put("measDataValue", measDataValue);
                            measDataInfo.put("measDataSource", 0);
                            insideMap.put(measitemCode, measDataInfo);
                        }
                    }
                    if (MapUtil.isNotEmpty(insideMap)) {
                        batchMeasDataInfosMap.put(measPointId.toString(), insideMap);
                    }
                }
            }

            //处理表计不存在的数据
            if (StringUtils.isNotEmpty(ca)){
                //获取原存在表计
                R<RunMeasPointListResponse> runMeasPointListBySn = dataCenterCommonService.getRunMeasPointListBySn(sn);
                RunMeasPointListResponse runMeasPointListResponse= runMeasPointListBySn.getData();
                List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
                List<String> measCommAddrList=runMeasPointList.stream().map(RunMeasPointVo::getMeasCommAddr).collect(Collectors.toList());
                //若不存在上报表计 则插入相应实体模型
                if (!measCommAddrList.contains(ca)) {
                    R flag = dataCenterCommonService.brushMeter(sn, ca, TopicEnum.JINHUA104.getTopic());
                    LOGGER.info("===================终端" + sn + "表计地址" + ca+"插入成功！！！");
                }
            }

            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
                //数据中心批量更新数据
                dataCenterCommonService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
                //数据中心批量更新量测点工况信息
                RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest = new RunMeasPointOpsInfoBatchUpdateRequest();
                runMeasPointOpsInfoBatchUpdateRequest.setMeasPointIdList(batchMeasDataInfosMap.keySet().stream().map(Long::valueOf).collect(Collectors.toList()));
                runMeasPointOpsInfoBatchUpdateRequest.setGmtMessageUp(now);
                runMeasPointOpsInfoBatchUpdateRequest.setGmtMeasdataUp(now);
                R runMeasPointOpsInfoBatchUpdateResponse = dataCenterCommonService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
            }

//            LOGGER.info("数据处理完成>>>:{}",JSONObject.toJSONString(batchMeasDataInfosMap));
            if (MapUtil.isNotEmpty(batchMeasDataInfosMap)) {
                //更新量测表计设备工况
                for (String pointIdString : batchMeasDataInfosMap.keySet()) {
                    Long pointId=Long.valueOf(pointIdString);
                    Map<String, Map<String, Object>> insideMap1 = batchMeasDataInfosMap.get(pointId.toString());
                    RemoteGmDevMeterGetRequest gmDevMeterGetRequest = new RemoteGmDevMeterGetRequest();
                    gmDevMeterGetRequest.setMeasPointId(pointId);
                    R<RemoteGmDevMeterGetResponse> r = remoteIotService.getGmDevMeter(gmDevMeterGetRequest);
                    RemoteGmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
                    if (r.getCode()==200&&r.getData().getGmDevMeter()!=null) {
                        RemoteGmDevMeterGetResponse remoteGmDevMeterGetResponse=r.getData();
                        gmopsDevMeterRefreshRequest = new RemoteGmopsDevMeterRefreshRequest();
                        gmopsDevMeterRefreshRequest.setDevMeterId(remoteGmDevMeterGetResponse.getGmDevMeter().getId());
                        gmopsDevMeterRefreshRequest.setGmtMessageUp(now);
                        gmopsDevMeterRefreshRequest.setGmtMeasdataUp(now);
                        Map<String, Object> measDataInfoSetMap = Maps.newHashMap();
                        for (String measItemCode : insideMap1.keySet()) {
                            Map<String, Object> measDataInfo1 = insideMap1.get(measItemCode);
                            gmopsDevMeterRefreshRequest.setGmtReadingUp(now);
                            measDataInfoSetMap.put(measItemCode, measDataInfo1.get("measDataValue"));
                        }
                        gmopsDevMeterRefreshRequest.setMeasDataInfoSet(JsonConvertUtils.convertToString(measDataInfoSetMap));
                    }
                    if (ObjectUtil.isNotEmpty(gmopsDevMeterRefreshRequest)) {
                        R<RemoteGmopsDevMeterRefreshResponse> remoteGmopsDevMeterRefreshResponseR = remoteIotService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
                    }
                }
            }

        }
    }

}
