package com.gaea.iesms.bm.mqttHandler.model.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2025/4/28 14:16
 */
// BMS电池堆设备数据实体类
@Data
public class BMSDeviceData {
    private String ca;
    // 数据时间点，相对于UTC-0 1970-1-1 0点的毫秒数
    private long ts;
    // 设备说明
    private Signature signature;
    // 设备工作状态
    private DevStatus devstatus;
    // 电池堆工作状态
    private int stack_status;
    // 电池堆充放状态
    private int charge_status;
    // 电池堆实时数据
    private Runtime runtime;
    // 该电池堆对应的电池簇数组
    private Cluster[] cluster;

    // 设备签名内部类，与PCS设备中的Signature类似
    @Data
    public static class Signature {
        private String type;
        private int id;
        private String name;
        private String display_name;
    }

    // 设备状态内部类，与PCS设备中的DevStatus类似
    @Data
    public static class DevStatus {
        private boolean online;
        private boolean run;
        private boolean alarm;
        private boolean fault;
    }

    // 电池堆运行时数据内部类
    @Data
    public static class Runtime {
        // 电压数据
        private Voltage voltage;
        // 电流数据
        private Current current;
        // 温度数据
        private Temperature temperature;
        // 电池SOC数据
        private SOC soc;
        // 电池健康度数据
        private SOH soh;
        // 功率
        private Power power;
        // 内阻数据
        private Resistance r;
        // 正极绝缘电阻数据
        private InsulationResistance positive_ir;
        // 负极绝缘电阻数据
        private InsulationResistance negative_ir;
        // 可放电量
        private double discharge_capacity;
    }

    // 电压数据内部类，结构与PCS设备中部分类似但含义不同
    @Data
    public static class Voltage {
        // 电堆电压
        private double mass;
        // 电堆内平均单体电压
        private double avg;
        // 电堆内最小单体电压
        private double min;
        // 电堆内最大单体电压
        private double max;
        // 电堆内最小单体电压的单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大单体电压的单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    @Data
    public static class Power {
        // 电堆电压
        private double mass;
        // 电堆内平均单体电压
        private double avg;
        // 电堆内最小单体电压
        private double min;
        // 电堆内最大单体电压
        private double max;
        // 电堆内最小单体电压的单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大单体电压的单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 电流数据内部类
    @Data
    public static class Current {
        // 电堆电流值
        private double mass;
        // 电堆内平均单体电流
        private double avg;
        // 电堆内最小单体电流
        private double min;
        // 电堆内最大单体电流
        private double max;
        // 电堆内最小单体电流的单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大单体电流的单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 温度数据内部类
    @Data
    public static class Temperature {
        // 电堆温度
        private double mass;
        // 电堆内平均单体温度
        private double avg;
        // 电堆内最小单体温度
        private double min;
        // 电堆内最大单体温度
        private double max;
        // 电堆内最小单体温度的单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大单体温度的单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 电池SOC数据内部类
    @Data
    public static class SOC {
        // 电堆SOC
        private double mass;
        // 电堆内单体SOC均值
        private double avg;
        // 电堆内单体SOC最小值
        private double min;
        // 电堆内单体SOC最大值
        private double max;
        // 电堆内最小SOC单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大SOC单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 电池健康度数据内部类
    @Data
    public static class SOH {
        // 电堆SOH
        private double mass;
        // 电堆内单体SOH均值
        private double avg;
        // 电堆内单体SOH最小值
        private double min;
        // 电堆内单体SOH最大值
        private double max;
        // 电堆内最小SOH单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大SOH单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 内阻数据内部类
    @Data
    public static class Resistance {
        // 电堆内阻
        private double mass;
        // 电堆内单体内阻均值
        private double avg;
        // 电堆内单体内阻最小值
        private double min;
        // 电堆内单体内阻最大值
        private double max;
        // 电堆内最小内阻单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大内阻单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 绝缘电阻数据内部类
    @Data
    public static class InsulationResistance {
        // 电堆绝缘电阻
        private double mass;
        // 电堆内单体绝缘电阻均值
        private double avg;
        // 电堆内单体绝缘电阻最小值
        private double min;
        // 电堆内单体绝缘电阻最大值
        private double max;
        // 电堆内最小绝缘电阻单体ID
        @JsonProperty("min_id")
        private int minId;
        // 电堆内最大绝缘电阻单体ID
        @JsonProperty("max_id")
        private int maxId;
    }

    // 电池簇内部类
    @Data
    public static class Cluster {
        // 设备工作状态
        private DevStatus devstatus;
        // 电池簇工作状态
        private int cluster_status;
        // 电池簇充放状态
        private int charge_status;
        // 簇运行时参数
        private ClusterRuntime runtime;
        // 该簇对应的单体电池数据数组
        private Battery[] battery;
    }

    // 电池簇运行时参数内部类
    @Data
    public static class ClusterRuntime {
        // 电压数据
        private Voltage voltage;
        // 电流数据
        private Current current;
        // 温度数据
        private Temperature temperature;
        // 电池SOC数据
        private SOC soc;
        // 电池健康度数据
        private SOH soh;
        // 内阻数据
        private Resistance r;
        // 正极绝缘电阻数据
        private InsulationResistance positive_ir;
        // 负极绝缘电阻数据
        private InsulationResistance negative_ir;
        // 可放电量
        private double discharge_capacity;
    }

    // 单体电池数据内部类
    @Data
    public static class Battery {
        // 单体电压
        private double voltage;
        // 单体温度
        private double temperature;
    }
}
