package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/device
 * 数据格式：
 * {
 *     "TimeStamp": 1514304211,
 *     "Lan": "wifi",
 *     "Category": "1",
 *     "ControllerID": "5a1e28dbd2b7fdc76c16aaff",
 *     "Version": "2.0.0",
 *     "Lines": [
 *         {
 *             "LineNo": 1,
 *             "LineID": "5a027116a3ab164c44620599"
 *         },
 *         {
 *             "LineNo": 1,
 *             "LineID": "5a027116a3ab164c44620599"
 *         }
 *     ]
 * }
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lan	设备上网方式，有WIFI、lan、LTE、GPRS等方式
 * 3	Category	设备类型
 * 4	ControllerID	设备ID
 * 5	Version	固件版本
 * 6	Lines	线路集合。LineNo表示线路编号，LineID表示线路ID
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayDeviceMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 8172115016857887015L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LAN")
    private String lan;

    @JsonProperty("CATEGORY")
    private String category;

    @JsonProperty("CONTROLLERID")
    private String controllerId;

    @JsonProperty("CLIENTID")
    private String clientId;

    @JsonProperty("SSID")
    private String ssid;

    @JsonProperty("VERSION")
    private String version;

    @JsonProperty("LINES")
    private List<GatewayDeviceLineMqttJsonDto> lines;

}
