package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/energy
 * 数据格式：
 * {
 *     "TimeStamp": 1491355918,
 *     "Lines": [
 *         {
 *             "LineNo": 1,
 *             "Energy": 0.12
 *         },
 *         {
 *             "LineNo": 2,
 *             "Energy": 0.19
 *         }
 *     ]
 * }
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合。LineNo表示线路编号，Energy表示线路用电量
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayEnergyMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -7278767430451266128L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayEnergyLineMqttJsonDto> lines;

}
