package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayParameter3MqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayParameter3LineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -6410776676080673020L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * 过载保护定值
     */
    @JsonProperty("CUR_MIX")
    private BigDecimal curMax;

    /**
     * 过载保护时间定值
     */
    @JsonProperty("CUR_T")
    private BigDecimal curTime;

    /**
     * 过压保护定值
     */
    @JsonProperty("OVER")
    private BigDecimal over;

    /**
     * 过压时间保护定值
     */
    @JsonProperty("OVER_T")
    private BigDecimal overTime;

    /**
     * 欠压保护定值
     */
    @JsonProperty("UNDER")
    private BigDecimal under;

    /**
     * 欠压时间保护定值
     */
    @JsonProperty("UNDER_T")
    private BigDecimal underTime;

    /**
     * 缺相保护定值
     */
    @JsonProperty("FAC")
    private BigDecimal fac;

    /**
     * 缺相时间保护定值
     */
    @JsonProperty("FAC_T")
    private BigDecimal facTime;

    /**
     * 温度保护定值
     */
    @JsonProperty("TMP_MAX")
    private BigDecimal tempMax;

    /**
     * 温度时间保护定值
     */
    @JsonProperty("TMP_T")
    private BigDecimal tempTime;

}
