package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：/productKey/ClientName/parameter
 * 数据格式：
 * {
 * 	"ControllerID": "589abebc690e76137c0f6472",
 * 	"Lines": [{
 * 			"LineNo": 1,
 * 			"Under": 170,
 * 			"Over": 270,
 * 			"Max": 63,
 * 			"LeakValue":10，
 * 	        "Err_LeakValue":20
 *        },
 *        {
 * 			"LineNo": 2,
 * 			"Under": 170,
 * 			"Over": 270,
 * 			"Max": 63,
 * 			"LeakValue":10,
 * 			"Err_LeakValue": 20
 *        }
 * 	]
 * }
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	ControllerID	设备ID
 * 2	LineNo	线路编号
 * 3	Under	欠压值
 * 4	Over	过压值
 * 5	Max	最大电流
 * 6	LeakValue	漏电预警值
 * 7	Err_LeakValue	漏电动作值
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayParameterMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 885493509878748867L;

    @JsonProperty("CONTROLLERID")
    private String controllerId;

    @JsonProperty("LINES")
    private List<GatewayParameterLineMqttJsonDto> lines;

}
