package com.gaea.iesms.bm.mqttHandler.task;

import com.easesource.commons.util.StringUtils;
import com.gaea.iesms.bm.mqttHandler.service.MqttmsgLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.regex.Pattern;

/**
 *
 */
@Component
public class DeleteDataTask {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteDataTask.class);


    @Resource
    private MqttmsgLogService mqttmsgLogService;

    @Scheduled(cron = "0 0 0 * * ? ")
    public void deleteData() {
        mqttmsgLogService.delete();
    }

    @PostConstruct
    public void init() {
        LOGGER.info("Bean初始化完成,删除3天前mqtt日志报文");
        // 在Bean初始化完成后执行一次任务
//        deleteData();
    }

    public static boolean isHexStrValid(String str, int length) {
        if(StringUtils.length(str) != length) {
            return false;
        }
        String pattern = "^[0-9a-fA-F]+$";
        return Pattern.compile(pattern).matcher(str).matches();
    }

}
