package com.gaea.iesms.bm.mqttHandler.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * 计算离散率
 * @author Lin yicheng
 * @date 2022/4/22 9:57
 */
@Component
public class DispersionRateUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(DispersionRateUtil.class);

    public BigDecimal calculate(List<BigDecimal> list) {
        BigDecimal dispersionRate = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(list)) {
            //求和
            BigDecimal sum = BigDecimal.ZERO;
            for(int i=0; i<list.size(); i++){
                sum = NumberUtil.add(sum,list.get(i));
            }
            //求平均数
            BigDecimal avg = NumberUtil.div(sum,list.size());
            //求标准差
            BigDecimal total = BigDecimal.ZERO;
            for(int i=0; i<list.size(); i++){
                total = NumberUtil.add(total,NumberUtil.mul(NumberUtil.sub(list.get(i),avg),NumberUtil.sub(list.get(i),avg)));
            }
            double standardDeviation = Math.sqrt(NumberUtil.div(total,list.size()).doubleValue());
            //计算离散率
            if (avg.compareTo(BigDecimal.ZERO) > 0) {
                dispersionRate = NumberUtil.mul(NumberUtil.div(standardDeviation,avg),100);
            }
        }
        return dispersionRate;
    }
}
