package com.gaea.iesms.bm.ops;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/22
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.ops.**", "com.gaea.mybatis.plus.**", "com.gaea.spring.cloud.starter.**"})
public class OpsStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(OpsStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
