package com.gaea.iesms.bm.standalone;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/22
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.standalone.**", "com.gaea.iesms.core.feign.**", "com.gaea.spring.cloud.starter.**"})
public class StandaloneStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(StandaloneStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
