package com.gaea.iesms.bm.standalone.config;

import com.gaea.iesms.bm.standalone.annotation.ExplainLogger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/3/23
 */
@Aspect
@Component
public class ExplainConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainConfig.class);

    @Pointcut("execution(public void com.gaea.iesms.bm.standalone.job.*.*(..))")
    public void webLog() {
    }

    @Before("webLog()")
    public void doBefore(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ExplainLogger annotation = method.getAnnotation(ExplainLogger.class);
        if (annotation != null) {
            LOGGER.info(">>> {} >>", annotation.value());
        }
    }

    /**
     * 环绕
     */
    @Around("webLog()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        MethodSignature methodSignature = (MethodSignature) proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ExplainLogger annotation = method.getAnnotation(ExplainLogger.class);
        Object result = proceedingJoinPoint.proceed();
        long endTime = System.currentTimeMillis();
        if (annotation != null) {
            long time = endTime - startTime;
            LOGGER.info(">>> {} [ runtime : {} ] >>", annotation.value(), time >= 1000 ? (time / 1000) + "s" : time + "ms");
        }
        return result;
    }
}
