package com.gaea.iesms.bm.standalone.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE)
@SuppressWarnings("all")
public class StatDataSourceConfig {

    @Primary
    @Bean(name = "statDataSource")
    @Qualifier("statDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.hikari.stat")
    DataSource statDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Primary
    @Bean(name = "statTransactionManager")
    @Qualifier("statTransactionManager")
    public DataSourceTransactionManager statTransactionManager(@Qualifier("statDataSource") DataSource statDataSource) {
        return new DataSourceTransactionManager(statDataSource);
    }
}
