package com.gaea.iesms.bm.standalone.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.standalone.service.BillingSchemeCustService;
import com.gaea.iesms.bm.standalone.service.BillingSchemeService;
import com.gaea.iesms.bm.standalone.service.BillingSchemeTemplateService;
import com.gaea.iesms.core.feign.request.BillingSchemeBindCustRelaRequest;
import com.gaea.iesms.core.feign.request.BillingSchemeInsertUpdateRequest;
import com.gaea.iesms.core.feign.request.BillingSchemeQueryRequest;
import com.gaea.iesms.core.feign.response.BillingSchemeVo;
import com.gaea.iesms.core.model.entity.standalone.BillingScheme;
import com.gaea.iesms.core.model.entity.standalone.BillingSchemeCust;
import com.gaea.iesms.core.model.entity.standalone.BillingSchemeTemplate;
import com.gaea.iesms.core.model.enums.standalone.BillingSchemeTemplateTypeEnum;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.utils.ConvertUtils;
import com.gaea.utils.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/10
 */
@RestController
@RequestMapping("billingScheme")
public class BillingSchemeController {

    @Resource
    private BillingSchemeCustService billingSchemeCustService;

    @Resource
    private BillingSchemeService billingSchemeService;

    @Resource
    private BillingSchemeTemplateService billingSchemeTemplateService;

    /**
     * 新增或修改计费方案
     *
     * @param request
     * @return
     */
    @PostMapping("insertUpdate")
    @Transactional(rollbackFor = Exception.class)
    public R<BillingSchemeVo> insertUpdate(@RequestBody BillingSchemeInsertUpdateRequest request) {
        BillingSchemeVo billingScheme = new BillingSchemeVo();
        billingScheme.setId(request.getSchemeId());
        billingScheme.setOrgNo(AuthUtils.getOrgNo());
        billingScheme.setCeSort(request.getCeSort().getValue());
        billingScheme.setSchemeNo(request.getSchemeNo());
        billingScheme.setSchemeName(request.getSchemeName());
        billingScheme.setSchemeDesc(request.getSchemeDesc());

        boolean save = true;
        if (billingScheme.getId() == null) {
            save = billingSchemeService.save(billingScheme);
        } else {
            billingSchemeService.updateById(billingScheme);
        }

        if (save) {
            Optional.ofNullable(request.getCeCustId()).ifPresent(ceCustId -> {
                BillingSchemeBindCustRelaRequest relaRequest = new BillingSchemeBindCustRelaRequest();
                relaRequest.setCeCustId(ceCustId);
                relaRequest.setSchemeId(billingScheme.getId());
                billingSchemeCustService.insert(relaRequest);
            });

            LambdaQueryWrapper<BillingSchemeTemplate> lambdaQueryWrapper = Wrappers.<BillingSchemeTemplate>lambdaQuery()
                    .eq(BillingSchemeTemplate::getSchemeId, billingScheme.getId());
            billingSchemeTemplateService.remove(lambdaQueryWrapper);

            billingScheme.setTemplateList(new ArrayList<>());

            // todo 基本电费
            Optional.ofNullable(request.getBasic()).ifPresent(basic -> {
                BillingSchemeTemplate template = new BillingSchemeTemplate();
                template.setSchemeId(billingScheme.getId());
                template.setTmplType(BillingSchemeTemplateTypeEnum.BASIC_COST.getValue());
                template.setTmplParams(basic);
                boolean bool = billingSchemeTemplateService.save(template);
                if (bool) {
                    billingScheme.getTemplateList().add(template);
                }
            });

            // todo 电度电费
            Optional.ofNullable(request.getDegree()).ifPresent(degree -> {
                BillingSchemeTemplate template = new BillingSchemeTemplate();
                template.setSchemeId(billingScheme.getId());
                template.setTmplType(BillingSchemeTemplateTypeEnum.DEGREE_COST.getValue());
                template.setTmplParams(degree);
                boolean bool = billingSchemeTemplateService.save(template);
                if (bool) {
                    billingScheme.getTemplateList().add(template);
                }
            });

            // todo 力调电费
            Optional.ofNullable(request.getAdjust()).ifPresent(adjust -> {
                BillingSchemeTemplate template = new BillingSchemeTemplate();
                template.setSchemeId(billingScheme.getId());
                template.setTmplType(BillingSchemeTemplateTypeEnum.ADJUST_COST.getValue());
                template.setTmplParams(adjust);
                boolean bool = billingSchemeTemplateService.save(template);
                if (bool) {
                    billingScheme.getTemplateList().add(template);
                }
            });
        }

        return R.ok(billingScheme);
    }

    /**
     * 查询计费方案（根据用能客户标识）
     *
     * @return
     */
    @GetMapping("getSchemeByCust")
    public R<BillingSchemeVo> get(@RequestParam("ceCustId") Long ceCustId) {
        LambdaQueryWrapper<BillingSchemeCust> lambdaQueryWrapper = Wrappers.<BillingSchemeCust>lambdaQuery()
                .eq(BillingSchemeCust::getCeCustId, ceCustId);
        BillingSchemeCust billingSchemeCust = billingSchemeCustService.getOne(lambdaQueryWrapper);
        if (billingSchemeCust != null) {
            BillingScheme billingScheme = billingSchemeService.getById(billingSchemeCust.getSchemeId());
            BillingSchemeVo billingSchemeVo = ConvertUtils.convert(BillingSchemeVo.class, billingScheme);
            if (billingSchemeVo != null) {
                LambdaQueryWrapper<BillingSchemeTemplate> lambdaQueryWrapper1 = Wrappers.<BillingSchemeTemplate>lambdaQuery()
                        .eq(BillingSchemeTemplate::getSchemeId, billingSchemeVo.getId());
                List<BillingSchemeTemplate> templateList = billingSchemeTemplateService.list(lambdaQueryWrapper1);
                billingSchemeVo.setTemplateList(templateList);
            }
            return R.ok(billingSchemeVo);
        }
        return R.ok();
    }

    @GetMapping("list")
    public R list(BillingSchemeQueryRequest request) {
        return null;
    }

    /**
     * 绑定计费方案和用能客户的关系
     *
     * @param request
     * @return
     */
    @PostMapping("bindCustRela")
    public R<Boolean> bindCustRela(@RequestBody BillingSchemeBindCustRelaRequest request) {
        return R.ok(billingSchemeCustService.insert(request));
    }
}
