package com.gaea.iesms.bm.standalone.controller;

import cn.hutool.core.collection.ListUtil;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.standalone.service.StatDataService;
import com.gaea.iesms.core.feign.request.*;
import com.gaea.iesms.core.feign.response.StandaloneDataInfoVo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/4
 */
@RestController
@RequestMapping("data")
public class StatDataController {

    @Resource
    private StatDataService dataService;

    /**
     * 获取曲线数据
     *
     * @param request
     * @return
     */
    @GetMapping("getCurve")
    public R<List<BigDecimal>> getCurve(StandaloneDataCurveRequest request) {
        return R.ok(dataService.getCurve(request));
    }

    /**
     * 获取范围曲线数据
     *
     * @param request
     * @return
     */
    @GetMapping("batchGetRangeCurve")
    public R<Map<String, List<BigDecimal>>> batchGetRangeCurve(StandaloneDataCurveBatchRangeRequest request) {
        return R.ok(dataService.batchGetRangeCurve(request));
    }

    /**
     * 批量获取曲线数据
     *
     * @param request
     * @return
     */
    @GetMapping("batchGetCurve")
    public R<Map<String, List<BigDecimal>>> batchGetCurve(StandaloneDataCurveBatchRequest request) {
        return R.ok(dataService.batchGetCurve(request));
    }

    /**
     * 获取数据信息
     *
     * @param request
     * @return
     */
    @GetMapping("getInfo")
    public R<StandaloneDataInfoVo> getInfo(StandaloneDataInfoRequest request) {
        StandaloneDataInfoBatchRequest req = new StandaloneDataInfoBatchRequest();
        req.setKeys(ListUtil.of(request.getKey()));
        req.setLevel(request.getLevel());
        req.setDateStat(request.getDateStat());
        return R.ok(dataService.batchGetInfo(req).get(request.getKey()));
    }

    /**
     * 批量获取数据信息
     *
     * @param request
     * @return
     */
    @GetMapping("batchGetInfo")
    public R<Map<String, StandaloneDataInfoVo>> batchGetInfo(StandaloneDataInfoBatchRequest request) {
        return R.ok(dataService.batchGetInfo(request));
    }
}
