package com.gaea.iesms.bm.standalone.job;

import com.gaea.iesms.bm.standalone.annotation.ExplainLogger;
import com.gaea.iesms.bm.standalone.service.StatAlarmService;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/3/22
 */
@Component
public class StatAlarmJob {

    private static Logger LOGGER = LoggerFactory.getLogger(StatAlarmJob.class);

    @Resource
    private StatAlarmService statAlarmService;

    @ExplainLogger("告警统计 采集终端通讯故障")
    @XxlJob("terminalCommFaultAlarm")
    public void terminalCommFaultAlarm() {
        try {
            statAlarmService.terminalCommFaultAlarm();
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("告警统计 采集终端采集故障")
    @XxlJob("terminalGatherWarningAlarm")
    public void terminalGatherWarningAlarm() {
        try {
            statAlarmService.terminalGatherWarningAlarm();
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("告警统计 量测表计采集故障")
    @XxlJob("meterGatherFaultAlarm")
    public void meterGatherFaultAlarm() {
        try {
            statAlarmService.meterGatherFaultAlarm();
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("告警统计 逆变器总线跳闸")
    @XxlJob("inverterBusTripAlarm")
    public void inverterBusTripAlarm() {
        try {
            statAlarmService.inverterBusTripAlarm();
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }
}
