package com.gaea.iesms.bm.standalone.job;

import cn.hutool.core.date.DateUtil;
import com.gaea.iesms.bm.standalone.annotation.ExplainLogger;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.service.StatEconsService;
import com.gaea.iesms.bm.standalone.util.StatisticsDateUtils;
import com.gaea.utils.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/25
 */
@Component
@SuppressWarnings("all")
public class StatEconsJob {

    private static Logger LOGGER = LoggerFactory.getLogger(StatEconsJob.class);
    private StatisticsDateDTO dateDTO;

    @Resource
    private StatEconsService statEconsService;

    @ExplainLogger("电量统计 用能点")
    @XxlJob("STAT-ECONS-POINT-JOB")
    public void startPointJob() {
        try {
            StatisticsDateDTO dateDTO = this.dateDTO = StatisticsDateUtils.date(XxlJobHelper.getJobParam());
            statEconsService.startPointDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 设备")
    @XxlJob("STAT-ECONS-DEVICE-JOB")
    public void startDeviceJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEconsService.startDeviceDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 容器")
    @XxlJob("STAT-ECONS-CONTAINER-JOB")
    public void startContainerJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEconsService.startContainerDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 区域")
    @XxlJob("STAT-ECONS-PART-JOB")
    public void startPartJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEconsService.startPartDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 客户")
    @XxlJob("STAT-ECONS-CUST-JOB")
    public void startCustJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEconsService.startCustDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 单位")
    @XxlJob("STAT-ECONS-ORG-JOB")
    public void startOrgJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEconsService.startOrgDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("电量统计 重跑")
    @XxlJob("STAT-ECONS-JOB")
    public void startJob() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isBlank(jobParam)) {
                return;
            }
            Date start = null;
            Date end = null;

            String[] split = jobParam.split("-");
            if (split.length == 1) {
                start = DateUtil.parse(split[0], "yyyy/MM/dd");
                end = DateUtil.parse(split[0], "yyyy/MM/dd");;
            } else {
                start = DateUtil.parse(split[0], "yyyy/MM/dd");
                end = DateUtil.parse(split[1], "yyyy/MM/dd");
            }

            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);

            while (calendar.getTime().before(end) || calendar.getTime().equals(end)) {
                StatisticsDateDTO dateDTO = StatisticsDateUtils.date(DateUtil.formatDate(calendar.getTime()));
                LOGGER.info(">>> 重跑：{}", dateDTO);

                statEconsService.startPointDayJob(dateDTO);
                statEconsService.startDeviceDayJob(dateDTO);
                statEconsService.startContainerDayJob(dateDTO);
                statEconsService.startPartDayJob(dateDTO);
                statEconsService.startCustDayJob(dateDTO);
                statEconsService.startOrgDayJob(dateDTO);

                calendar.add(Calendar.DAY_OF_MONTH, 1);
            }
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }
}
