package com.gaea.iesms.bm.standalone.job;

import cn.hutool.core.date.DateUtil;
import com.gaea.iesms.bm.standalone.annotation.ExplainLogger;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.service.StatEloadService;
import com.gaea.iesms.bm.standalone.util.StatisticsDateUtils;
import com.gaea.utils.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/11/29
 */
@Component
@SuppressWarnings("all")
public class StatEloadJob {

    private static Logger LOGGER = LoggerFactory.getLogger(StatEloadJob.class);
    private StatisticsDateDTO dateDTO;

    @Resource
    private StatEloadService statEloadService;

    @ExplainLogger("负荷统计 用能点")
    @XxlJob("STAT-ELOAD-POINT-JOB")
    public void startPointJob() {
        try {
            StatisticsDateDTO dateDTO = this.dateDTO = StatisticsDateUtils.date(XxlJobHelper.getJobParam());
            statEloadService.startPointDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 设备")
    @XxlJob("STAT-ELOAD-DEVICE-JOB")
    public void startDeviceJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEloadService.startDeviceDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 容器")
    @XxlJob("STAT-ELOAD-CONTAINER-JOB")
    public void startContainerJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEloadService.startContainerDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 区域")
    @XxlJob("STAT-ELOAD-PART-JOB")
    public void startPartJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEloadService.startPartDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 客户")
    @XxlJob("STAT-ELOAD-CUST-JOB")
    public void startCustJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEloadService.startCustDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 单位")
    @XxlJob("STAT-ELOAD-ORG-JOB")
    public void startOrgJob() {
        try {
            StatisticsDateDTO dateDTO = StringUtils.isNotBlank(XxlJobHelper.getJobParam()) ? StatisticsDateUtils.date(XxlJobHelper.getJobParam()) : this.dateDTO;
            statEloadService.startOrgDayJob(dateDTO);
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @ExplainLogger("负荷统计 重跑")
    @XxlJob("STAT-ELOAD-JOB")
    public void startJob() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isBlank(jobParam)) {
                return;
            }
            Date start = null;
            Date end = null;

            String[] split = jobParam.split("-");
            if (split.length == 1) {
                start = DateUtil.parse(split[0], "yyyy/MM/dd");
                end = DateUtil.parse(split[0], "yyyy/MM/dd");
                ;
            } else {
                start = DateUtil.parse(split[0], "yyyy/MM/dd");
                end = DateUtil.parse(split[1], "yyyy/MM/dd");
            }

            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);

            while (calendar.getTime().before(end) || calendar.getTime().equals(end)) {
                StatisticsDateDTO dateDTO = StatisticsDateUtils.date(DateUtil.formatDate(calendar.getTime()));
                LOGGER.info(">>> 重跑：{}", dateDTO);

                statEloadService.startPointDayJob(dateDTO);
                statEloadService.startDeviceDayJob(dateDTO);
                statEloadService.startContainerDayJob(dateDTO);
                statEloadService.startPartDayJob(dateDTO);
                statEloadService.startCustDayJob(dateDTO);
                statEloadService.startOrgDayJob(dateDTO);

                calendar.add(Calendar.DAY_OF_MONTH, 1);
            }
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }
}
