package com.gaea.iesms.bm.standalone.job;

import com.gaea.iesms.bm.standalone.annotation.ExplainLogger;
import com.gaea.iesms.bm.standalone.service.StatStatusService;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/22
 */
@Component
public class StatStatusJob {

    private static Logger LOGGER = LoggerFactory.getLogger(StatStatusJob.class);

    @Resource
    private StatStatusService statStatusService;

    @ExplainLogger("状态统计 逆变器状态")
    @XxlJob("inverterStatus")
    public void inverterStatus() {
        try {
            statStatusService.inverterStatus();
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }
}
