package com.gaea.iesms.bm.standalone.mapper;

import cn.hutool.core.lang.Dict;
import com.gaea.iesms.bm.standalone.model.dto.StandaloneDataInfoDTO;
import com.gaea.iesms.core.feign.response.StandaloneDataInfoVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/4
 */
public interface StatDataMapper {

    /**
     * 获取设备日曲线数据
     *
     * @param keys
     * @param type
     * @param dateValue
     * @return
     */
    List<Dict> getDeviceCurveDay(@Param("keys") List<String> keys, @Param("type") String type, @Param("dateValue") String dateValue);

    /**
     * 获取设备月曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getDeviceCurveMonth(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Date startDate, @Param("endDate") Date endDate);

    /**
     * 获取设备年曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getDeviceCurveYear(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Integer startDate, @Param("endDate") Integer endDate);

    /**
     * 获取容器日曲线数据
     *
     * @param keys
     * @param type
     * @param dateValue
     * @return
     */
    List<Dict> getContainerCurveDay(@Param("keys") List<String> keys, @Param("type") String type, @Param("dateValue") String dateValue);

    /**
     * 获取容器日曲线数据（范围）
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @param dateList
     * @return
     */
    List<Dict> getContainerRangeCurveDay(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Date startDate, @Param("endDate") Date endDate, @Param("dateList") List<String> dateList);

    /**
     * 获取容器月曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getContainerCurveMonth(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Date startDate, @Param("endDate") Date endDate);

    /**
     * 获取容器月曲线数据（范围）
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @param dateList
     * @return
     */
    List<Dict> getContainerRangeCurveMonth(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") String startDate, @Param("endDate") String endDate, @Param("dateList") List<String> dateList);

    /**
     * 获取容器年曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getContainerCurveYear(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Integer startDate, @Param("endDate") Integer endDate);

    /**
     * 获取客户日曲线数据
     *
     * @param keys
     * @param type
     * @param dateValue
     * @return
     */
    List<Dict> getCustCurveDay(@Param("keys") List<String> keys, @Param("type") String type, @Param("dateValue") String dateValue);

    /**
     * 获取客户月曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getCustCurveMonth(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Date startDate, @Param("endDate") Date endDate);

    /**
     * 获取客户年曲线数据
     *
     * @param keys
     * @param type
     * @param startDate
     * @param endDate
     * @return
     */
    List<Dict> getCustCurveYear(@Param("keys") List<String> keys, @Param("type") String type, @Param("startDate") Integer startDate, @Param("endDate") Integer endDate);

    /**
     * 获取设备数据信息
     *
     * @param keys
     * @return
     */
    List<StandaloneDataInfoDTO> getDeviceInfo(@Param("keys") List<String> keys, @Param("date") String date);

    /**
     * 获取容器数据信息
     *
     * @param keys
     * @return
     */
    List<StandaloneDataInfoDTO> getContainerInfo(@Param("keys") List<String> keys, @Param("date") String date);

    /**
     * 获取区域数据信息
     *
     * @param keys
     * @return
     */
    List<StandaloneDataInfoDTO> getPartInfo(@Param("keys") List<String> keys, @Param("date") String date);

    /**
     * 获取客户数据信息
     *
     * @param keys
     * @return
     */
    List<StandaloneDataInfoDTO> getCustInfo(@Param("keys") List<String> keys, @Param("date") String date);
}
