package com.gaea.iesms.bm.standalone.mapper;

import com.gaea.iesms.core.model.entity.standalone.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/17
 */
@Mapper
public interface StatEconsSelectMapper {

    /**
     * 查询用能点月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCepointEconsMonth> selectCePointMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询用能点年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCepointEconsYear> selectCePointYear(@Param("start") Integer start, @Param("end") Integer end);

    /**
     * 查询设备用能点数据
     *
     * @param date
     * @return
     */
    List<StatCedeviceEconsDay> selectCeDevicePointDay(@Param("date") Date date);

    /**
     * 查询设备月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCedeviceEconsMonth> selectCeDeviceMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询设备年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCedeviceEconsYear> selectCeDeviceYear(@Param("start") Integer start, @Param("end") Integer end);

    /**
     * 查询容器用能点数据
     *
     * @param date
     * @return
     */
    List<StatCecntrEconsDay> selectCeContainerPointDay(@Param("date") Date date);

    /**
     * 查询容器表计数据
     *
     * @param id
     * @param date
     * @return
     */
    StatCecntrEconsDay selectCeContainerMeterDay(@Param("id") Long id, @Param("date") String date);

    /**
     * 查询容器设备数据
     *
     * @param date
     * @return
     */
    StatCecntrEconsDay selectCeContainerDeviceDay(@Param("id") Long id, @Param("date") String date);

    /**
     * 查询上级容器数据
     *
     * @param date
     * @return
     */
    List<StatCecntrEconsDay> selectCeContainerParentDay(@Param("date") String date);

    /**
     * 查询容器月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCecntrEconsMonth> selectCeContainerMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询容器年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCecntrEconsYear> selectCeContainerYear(@Param("start") Integer start, @Param("end") Integer end);

    /**
     * 查询区域用能点数据
     *
     * @param date
     * @return
     */
    List<StatCepartEconsDay> selectCePartPointDay(@Param("date") String date);

    /**
     * 查询区域容器数据
     *
     * @param date
     * @return
     */
    List<StatCepartEconsDay> selectCePartContainerDay(@Param("date") String date);

    /**
     * 查询区域设备数据
     *
     * @param date
     * @return
     */
    List<StatCepartEconsDay> selectCePartDeviceDay(@Param("date") String date);

    /**
     * 查询区域月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCepartEconsMonth> selectCePartMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询区域年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCepartEconsYear> selectCePartYear(@Param("start") Integer start, @Param("end") Integer end);

    /**
     * 查询客户用能点数据
     *
     * @param date
     * @return
     */
    List<StatCecustEconsDay> selectCeCustPointDay(@Param("date") String date);

    /**
     * 查询客户区域数据
     *
     * @param date
     * @return
     */
    List<StatCecustEconsDay> selectCeCustPartDay(@Param("date") String date);

    /**
     * 查询客户容器数据
     *
     * @param date
     * @return
     */
    List<StatCecustEconsDay> selectCeCustContainerDay(@Param("date") String date);

    /**
     * 查询客户设备数据
     *
     * @param date
     * @return
     */
    List<StatCecustEconsDay> selectCeCustDeviceDay(@Param("date") String date);

    /**
     * 查询客户月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCecustEconsMonth> selectCeCustMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询客户年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatCecustEconsYear> selectCeCustYear(@Param("start") Integer start, @Param("end") Integer end);

    /**
     * 查询统计客户累计
     *
     * @return
     */
    List<StatCecustEconsDay> selectCeCustAccum();

    /**
     * 查询单位客户数据
     *
     * @param date
     * @return
     */
    List<StatOrgEconsDay> selectOrgCustDay(@Param("date") String date);

    /**
     * 查询上级单位数据
     *
     * @param orgNo
     * @param date
     * @return
     */
    StatOrgEconsDay selectOrgParentDay(@Param("orgNo") String orgNo, @Param("date") String date);

    /**
     * 查询单位月数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatOrgEconsMonth> selectOrgMonth(@Param("start") Date start, @Param("end") Date end);

    /**
     * 查询单位年数据
     *
     * @param start
     * @param end
     * @return
     */
    List<StatOrgEconsYear> selectOrgYear(@Param("start") Integer start, @Param("end") Integer end);
}
