package com.gaea.iesms.bm.standalone.mapper;

import com.gaea.iesms.core.model.entity.standalone.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/11/30
 */
@Mapper
public interface StatEloadSelectMapper {

    /**
     * 查询设备用能点数据
     *
     * @param date
     * @return
     */
    List<StatCedeviceEloadDay> selectCeDevicePointDay(@Param("date") String date);

    /**
     * 查询容器用能点数据
     *
     * @param date
     * @return
     */
    List<StatCecntrEloadDay> selectContainerPointDay(@Param("date") String date);

    /**
     * 查询容器关联表计数据
     *
     * @param id
     * @param date
     * @return
     */
    StatCecntrEloadDay selectContainerMeterDay(@Param("id") Long id, @Param("date") String date);

    /**
     * 查询容器下的设备数据
     *
     * @param id
     * @param date
     * @return
     */
    StatCecntrEloadDay selectContainerDeviceDay(@Param("id") Long id, @Param("date") String date);

    /**
     * 查找上级容器数据
     *
     * @param date
     * @return
     */
    List<StatCecntrEloadDay> selectContainerParentDay(@Param("date") String date);

    List<StatCepartEloadDay> selectPartPointDay(@Param("date") String date);

    List<StatCepartEloadDay> selectPartContainerDay(@Param("date") String date);

    List<StatCepartEloadDay> selectPartDeviceDay(@Param("date") String date);

    /**
     * 查询用户关联用能点数据
     *
     * @param date
     * @return
     */
    List<StatCecustEloadDay> selectCustPointDay(@Param("date") String date);

    /**
     * 查询用户关联区域数据
     *
     * @param date
     * @return
     */
    List<StatCecustEloadDay> selectCustPartDay(@Param("date") String date);

    /**
     * 查询用户关联容器数据
     *
     * @param date
     * @return
     */
    List<StatCecustEloadDay> selectCustContainerDay(@Param("date") String date);

    /**
     * 查询用户关联设备数据
     *
     * @param date
     * @return
     */
    List<StatCecustEloadDay> selectCustDeviceDay(@Param("date") String date);

    /**
     * 查询单位下的所有用户数据
     *
     * @param date
     * @return
     */
    List<StatOrgEloadDay> selectOrgCustDay(@Param("date") String date);

    /**
     * 查询上级单位数据
     *
     * @param orgNo
     * @param date
     * @return
     */
    StatOrgEloadDay selectOrgParentDay(@Param("orgNo") String orgNo, @Param("date") String date);
}
