package com.gaea.iesms.bm.standalone.model.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gaea.base.typehandler.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/25
 */
@Data
public class StandaloneDataInfoDTO implements Serializable {

    private static final long serialVersionUID = 2151597582418662665L;

    /**
     * 数据标识
     */
    private String key;

    /**
     * 实时负荷
     */
    private BigDecimal curEloadVal;

    /**
     * 最大负荷值
     */
    private BigDecimal maxEloadVal;

    /**
     * 最大负荷值发生时间
     */
    private Date maxEloadValTime;

    /**
     * 最小负荷值
     */
    private BigDecimal minEloadVal;

    /**
     * 最小负荷值发生时间
     */
    private Date minEloadValTime;

    /**
     * 日总电量
     */
    private BigDecimal econsValDay;

    /**
     * 日尖电量
     */
    private BigDecimal econsValDr1;

    /**
     * 日峰电量
     */
    private BigDecimal econsValDr2;

    /**
     * 日平电量
     */
    private BigDecimal econsValDr3;

    /**
     * 日谷电量
     */
    private BigDecimal econsValDr4;

    /**
     * 日总计费值
     */
    private BigDecimal expenseDay;

    /**
     * 日尖计费值
     */
    private BigDecimal expenseDr1;

    /**
     * 日峰计费值
     */
    private BigDecimal expenseDr2;

    /**
     * 日平计费值
     */
    private BigDecimal expenseDr3;

    /**
     * 日谷计费值
     */
    private BigDecimal expenseDr4;

    /**
     * 日等效时数
     */
    private BigDecimal eqHoursDay;

    /**
     * 当月电量
     */
    private BigDecimal econsValMonth;

    /**
     * 月尖电量
     */
    private BigDecimal econsValMr1;

    /**
     * 月峰电量
     */
    private BigDecimal econsValMr2;

    /**
     * 月平电量
     */
    private BigDecimal econsValMr3;

    /**
     * 月谷电量
     */
    private BigDecimal econsValMr4;

    /**
     * 月总计费值
     */
    private BigDecimal expenseMonth;

    /**
     * 月尖计费值
     */
    private BigDecimal expenseMr1;

    /**
     * 月峰计费值
     */
    private BigDecimal expenseMr2;

    /**
     * 月平计费值
     */
    private BigDecimal expenseMr3;

    /**
     * 月谷计费值
     */
    private BigDecimal expenseMr4;

    /**
     * 当年电量
     */
    private BigDecimal econsValYear;

    /**
     * 年尖用电量
     */
    private BigDecimal econsValYr1;

    /**
     * 年峰用电量
     */

    private BigDecimal econsValYr2;

    /**
     * 年平用电量
     */
    private BigDecimal econsValYr3;

    /**
     * 年谷用电量
     */
    private BigDecimal econsValYr4;

    /**
     * 年总计费值
     */
    private BigDecimal expenseYear;

    /**
     * 年尖计费值
     */
    private BigDecimal expenseYr1;

    /**
     * 年峰计费值
     */
    private BigDecimal expenseYr2;

    /**
     * 年平计费值
     */
    private BigDecimal expenseYr3;

    /**
     * 年谷计费值
     */
    private BigDecimal expenseYr4;

    /**
     * 累计总电量
     */
    private BigDecimal econsValAccum;

    /**
     * 累计尖电量
     */
    private BigDecimal econsValAr1;

    /**
     * 累计峰电量
     */
    private BigDecimal econsValAr2;

    /**
     * 累计平电量
     */
    private BigDecimal econsValAr3;

    /**
     * 累计谷电量
     */
    private BigDecimal econsValAr4;

    /**
     * 累计总计费值
     */
    private BigDecimal expenseAccum;

    /**
     * 累计尖计费值
     */
    private BigDecimal expenseAr1;

    /**
     * 累计峰计费值
     */
    private BigDecimal expenseAr2;

    /**
     * 累计平计费值
     */
    private BigDecimal expenseAr3;

    /**
     * 累计谷计费值
     */
    private BigDecimal expenseAr4;

    /**
     * 累计等效时数
     */
    private BigDecimal eqHoursAccum;

    /**
     * 状态
     */
    private Integer opsStatus;
}
