package com.gaea.iesms.bm.standalone.model.enums;

import com.gaea.base.core.IBaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import static com.gaea.iesms.bm.standalone.model.enums.StandaloneDateTypeEnum.DAY;
import static com.gaea.iesms.bm.standalone.model.enums.StandaloneDateTypeEnum.MONTH;
import static com.gaea.iesms.bm.standalone.model.enums.StandaloneDateTypeEnum.YEAR;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/30
 */
@AllArgsConstructor
@Getter
public enum StandaloneDataTypeEnum implements IBaseEnum<String> {

    DEVICE_ECONS_DAY("DEVICEECONSDAY", DAY, "设备日电量"),

    DEVICE_ECONS_MONTH("DEVICEECONSMONTH", MONTH, "设备月电量"),

    DEVICE_ECONS_YEAR("DEVICEECONSYEAR", YEAR, "设备年电量"),

    CONTAINER_ECONS_DAY("CONTAINERECONSDAY", DAY, "容器日电量"),

    CONTAINER_ECONS_MONTH("CONTAINERECONSMONTH", MONTH, "容器月电量"),

    CONTAINER_ECONS_YEAR("CONTAINERECONSYEAR", YEAR, "容器年电量"),

    CONTAINER_ECONS1_DAY("CONTAINERECONS1DAY", DAY, "容器日尖电量"),

    CONTAINER_ECONS1_MONTH("CONTAINERECONS1MONTH", MONTH, "容器月尖电量"),

    CONTAINER_ECONS1_YEAR("CONTAINERECONS1YEAR", YEAR, "容器年尖电量"),

    CONTAINER_ECONS2_DAY("CONTAINERECONS2DAY", DAY, "容器日峰电量"),

    CONTAINER_ECONS2_MONTH("CONTAINERECONS2MONTH", MONTH, "容器月峰电量"),

    CONTAINER_ECONS2_YEAR("CONTAINERECONS2YEAR", YEAR, "容器年峰电量"),

    CONTAINER_ECONS3_DAY("CONTAINERECONS3DAY", DAY, "容器日平电量"),

    CONTAINER_ECONS3_MONTH("CONTAINERECONS3MONTH", MONTH, "容器月平电量"),

    CONTAINER_ECONS3_YEAR("CONTAINERECONS3YEAR", YEAR, "容器年平电量"),

    CONTAINER_ECONS4_DAY("CONTAINERECONS4DAY", DAY, "容器日谷电量"),

    CONTAINER_ECONS4_MONTH("CONTAINERECONS4MONTH", MONTH, "容器月谷电量"),

    CONTAINER_ECONS4_YEAR("CONTAINERECONS4YEAR", YEAR, "容器年谷电量"),

    ;

    private final String value;
    private final StandaloneDateTypeEnum date;
    private final String name;
}
