package com.gaea.iesms.bm.standalone.model.enums;

import com.gaea.base.core.IBaseEnum;
import com.gaea.utils.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/30
 */
@AllArgsConstructor
@Getter
public enum StandaloneDateTypeEnum implements IBaseEnum<String> {

    /**
     * 日
     */
    DAY("DAY", "yyyy-MM-dd", "日"),

    /**
     * 月
     */
    MONTH("MONTH", "yyyy-MM", "月"),

    /**
     * 年
     */
    YEAR("YEAR", "yyyy", "年"),

    ;

    private final String value;
    private final String pattern;
    private final String name;

    public static StandaloneDateTypeEnum getByValue(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        for (StandaloneDateTypeEnum dateTypeEnum : StandaloneDateTypeEnum.values()) {
            if (StringUtils.equals(dateTypeEnum.getValue(), value)) {
                return dateTypeEnum;
            }
        }
        return null;
    }
}
