package com.gaea.iesms.bm.standalone.service;

import com.gaea.iesms.core.feign.request.*;
import com.gaea.iesms.core.feign.response.StandaloneDataInfoVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/4
 */
public interface StatDataService {

    /**
     * 获取曲线数据
     *
     * @param request
     * @return
     */
    List<BigDecimal> getCurve(StandaloneDataCurveRequest request);

    /**
     * 批量获取数据信息
     *
     * @param request
     * @return
     */
    Map<String, StandaloneDataInfoVo> batchGetInfo(StandaloneDataInfoBatchRequest request);

    /**
     * 批量获取曲线数据
     *
     * @param request
     * @return
     */
    Map<String, List<BigDecimal>> batchGetCurve(StandaloneDataCurveBatchRequest request);

    /**
     * 获取范围曲线数据
     *
     * @param request
     * @return
     */
    Map<String, List<BigDecimal>> batchGetRangeCurve(StandaloneDataCurveBatchRangeRequest request);
}
