package com.gaea.iesms.bm.standalone.service;

import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDayDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsMonthDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsYearDateDTO;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/25
 */
public interface StatEconsService {

    /**
     * 用能点日统计
     *
     * @param dateDTO
     */
    void startPointDayJob(StatisticsDateDTO dateDTO);

    /**
     * 用能点月统计
     *
     * @param dateDTO
     */
    void startPointMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 用能点年统计
     *
     * @param dateDTO
     */
    void startPointYearJob(StatisticsYearDateDTO dateDTO);

    /**
     * 设备日统计
     *
     * @param dateDTO
     */
    void startDeviceDayJob(StatisticsDateDTO dateDTO);

    /**
     * 设备月统计
     *
     * @param dateDTO
     */
    void startDeviceMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 设备年统计
     *
     * @param dateDTO
     */
    void startDeviceYearJob(StatisticsYearDateDTO dateDTO);

    /**
     * 容器日统计
     *
     * @param dateDTO
     */
    void startContainerDayJob(StatisticsDateDTO dateDTO);

    /**
     * 容器月统计
     *
     * @param dateDTO
     */
    void startContainerMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 容器年统计
     *
     * @param dateDTO
     */
    void startContainerYearJob(StatisticsYearDateDTO dateDTO);

    /**
     * 区域日统计
     *
     * @param dateDTO
     */
    void startPartDayJob(StatisticsDateDTO dateDTO);

    /**
     * 区域月统计
     *
     * @param dateDTO
     */
    void startPartMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 区域年统计
     *
     * @param dateDTO
     */
    void startPartYearJob(StatisticsYearDateDTO dateDTO);

    /**
     * 客户日统计
     *
     * @param dateDTO
     */
    void startCustDayJob(StatisticsDateDTO dateDTO);

    /**
     * 客户月统计
     *
     * @param dateDTO
     */
    void startCustMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 客户年统计
     *
     * @param dateDTO
     */
    void startCustYearJob(StatisticsYearDateDTO dateDTO);

    /**
     * 单位日统计
     *
     * @param dateDTO
     */
    void startOrgDayJob(StatisticsDateDTO dateDTO);

    /**
     * 单位月统计
     *
     * @param dateDTO
     */
    void startOrgMonthJob(StatisticsMonthDateDTO dateDTO);

    /**
     * 单位年统计
     *
     * @param dateDTO
     */
    void startOrgYearJob(StatisticsYearDateDTO dateDTO);
}
